% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-noise.R
\name{layer_gaussian_noise}
\alias{layer_gaussian_noise}
\title{Apply additive zero-centered Gaussian noise.}
\usage{
layer_gaussian_noise(object, stddev, seed = NULL, ...)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{stddev}{float, standard deviation of the noise distribution.}

\item{seed}{Integer, optional random seed to enable deterministic behavior.}

\item{...}{standard layer arguments.}
}
\description{
This is useful to mitigate overfitting (you could see it as a form of random
data augmentation). Gaussian Noise (GS) is a natural choice as corruption
process for real valued inputs. As it is a regularization layer, it is only
active at training time.
}
\section{Input shape}{
 Arbitrary. Use the keyword argument \code{input_shape} (list
of integers, does not include the samples axis) when using this layer as
the first layer in a model.
}

\section{Output shape}{
 Same shape as input.
}

\seealso{
Other noise layers: 
\code{\link{layer_alpha_dropout}()},
\code{\link{layer_gaussian_dropout}()}
}
\concept{noise layers}
