% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{evaluate}
\alias{evaluate}
\title{Evaluate a Keras model}
\usage{
evaluate(object, x, y, batch_size = 32, verbose = 1, sample_weight = NULL)
}
\arguments{
\item{object}{Model object to evaluate}

\item{x}{Vector, matrix, or array of training data (or list if the model has
multiple inputs). If all inputs in the model are named, you can also pass a
list mapping input names to data.}

\item{y}{Vector, matrix, or array of target data (or list if the model has
multiple outputs). If all outputs in the model are named, you can also pass
a list mapping output names to data.}

\item{batch_size}{Number of samples per gradient update.}

\item{verbose}{Verbosity mode (0 = silent, 1 = verbose, 2 = one log line per
epoch).}

\item{sample_weight}{Optional array of the same length as x, containing
weights to apply to the model's loss for each sample. In the case of
temporal data, you can pass a 2D array with shape (samples,
sequence_length), to apply a different weight to every timestep of every
sample. In this case you should make sure to specify
sample_weight_mode="temporal" in \code{\link[=compile]{compile()}}.}
}
\value{
Scalar test loss (if the model has a single output and no metrics) or
list of scalars (if the model has multiple outputs and/or metrics).
}
\description{
Evaluate a Keras model
}
\seealso{
Other model functions: \code{\link{compile}},
  \code{\link{evaluate_generator}},
  \code{\link{fit_generator}}, \code{\link{fit}},
  \code{\link{get_config}}, \code{\link{get_layer}},
  \code{\link{keras_model_sequential}},
  \code{\link{keras_model}}, \code{\link{pop_layer}},
  \code{\link{predict.keras.engine.training.Model}},
  \code{\link{predict_generator}},
  \code{\link{predict_on_batch}},
  \code{\link{predict_proba}},
  \code{\link{summary.keras.engine.training.Model}},
  \code{\link{train_on_batch}}
}
