% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builtin_starts_list.R
\name{parametric_starts}
\alias{parametric_starts}
\title{Parametric starts}
\description{
A parametric start is a density function with an associated estimator which
is used as a starting point in \code{kdensity}. Several parametric starts
are implemented, all with maximum likelihood estimation. Custom-made
parametric starts are possible, see the Structure section.
}
\section{Structure}{

The parametric start contains three elements: The density function, an
estimation function, and the support of the density. The parameters of
the density function must partially match the parameters of the estimator
function. The estimator function takes one argument, a numeric vector,
which is passed from \code{kdensity}.
}

\section{Supported parametric starts}{
 \code{kdensity} supports more than
20 built-in starts from the \link{univariateML} package, see
\code{univariateML::univariateML_models} for a list. Densities with variable
support, \code{power}, are not supported. The \code{pareto} density has its
support fixed to \verb{(1,Inf)}. The
options \verb{uniform, constant} makes \code{kdensity} estimate a kernel
density without parametric starts.
}

\examples{
start_exponential = list(
 density = stats::dexp,
 estimator = function(data) {
   c(rate = 1/mean(data))
 },
 support = c(0, Inf)
)

start_inverse_gaussian = list(
 density = extraDistr::dwald,
 estimator = function(data) {
  c(mu = mean(data),
    lambda = mean(1/data - 1/mean(data)))
  },
 support = c(0, Inf)
)

}
\seealso{
\code{\link[=kdensity]{kdensity()}}; \code{\link[=kernels]{kernels()}}; \code{\link[=bandwidths]{bandwidths()}}
}
