% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa.R
\name{kappa_test}
\alias{kappa_test}
\title{Significance test for homogeneity of kappa coefficients}
\usage{
kappa_test(kappas, val = "value0", se = "se0", conf.level = 0.95)
}
\arguments{
\item{kappas}{list of kappas from different groups. It uses the kappa
estimate and its standard error.}

\item{val}{character. Name of field to extract kappa coefficient estimate.}

\item{se}{character. Name of field to extract standard error of kappa.}

\item{conf.level}{numeric. confidence level of confidence interval for
overall kappa}
}
\value{
list containing the test results, including the entries \code{statistic}
and \code{p.value} (class \code{htest})
}
\description{
When groups of different subjects are rated on a nominal scale. Assuming
independence of subjects and their ratings between groups a chi-squared test
for equality of kappa between these groups is performed. The test requires
estimates of kappa and its standard error per group.
}
\details{
A common overall kappa coefficient across groups is estimated. The test
statistic assesses the weighted squared deviance of the individual kappas
from the overall kappa estimate. The weights depend on the provided standard
errors.
}
\examples{
# script concordance test on 34 clinical situations,
# rated by 39 students and 11 experts
kappa_stud <- kappam_fleiss(SC_test[, 1:39])
kappa_expert <- kappam_fleiss(SC_test[, 40:50])

# compare student and expert agreement
kappa_test(kappas = list(kappa_stud, kappa_expert))


}
\references{
Joseph L. Fleiss, Statistical Methods for Rates and Proportions,
3rd ed., 2003, section 18.1
}
