% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_helper.R
\name{block_rename}
\alias{block_rename}
\title{block_rename}
\usage{
block_rename(block, pred.names)
}
\arguments{
\item{block}{A dlm_block object.}

\item{pred.names}{A vector of string with names for each linear predictor in block.}
}
\value{
A dlm_block with the linear predictors renamed to the values passed in names.
}
\description{
block_rename
}
\examples{

base.block <- polynomial_block(
  eta = 1,
  order = 1,
  name = "Poly",
  D = 0.95
)

final.block <- block_rename(2 * base.block, c("mu", "sigma"))

}
\seealso{
Other auxiliary functions for structural blocks: 
\code{\link{TF_block}()},
\code{\link{block_mult}()},
\code{\link{block_superpos}()},
\code{\link{harmonic_block}()},
\code{\link{intervention}()},
\code{\link{noise_block}()},
\code{\link{polynomial_block}()},
\code{\link{regression_block}()},
\code{\link{specify.dlm_block}()},
\code{\link{summary.dlm_block}()}
}
\concept{auxiliary functions for structural blocks}
