% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_id.R
\name{generate_id}
\alias{generate_id}
\title{Generate unique identifier(s)}
\usage{
generate_id(
  type,
  prefix = paste(sample(letters, 4), collapse = ""),
  stopOnIllegalChars = FALSE
)
}
\arguments{
\item{type}{The type of the justifier object; \code{D}, \code{J}, \code{A} or \code{S}.}

\item{prefix}{An identifier prefix.}

\item{stopOnIllegalChars}{Whether to \code{\link[base:stop]{base::stop()}} or produce a \code{\link[base:warning]{base::warning()}}
when encountering illegal characters (i.e. anything other than a letter or
underscore).}
}
\value{
A character vector containing the identifier(s).
}
\description{
Convenience function to generate a unique identifiers for
sources, assertions, justifications, and decisions.
}
\examples{
generate_id(type = "S", 'sourceExample');
generate_id(type = "A", 'assertionExample');
}
