% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_fin_chrom.R
\name{sim_fin_chrom}
\alias{sim_fin_chrom}
\title{Individual Based Simulation of the accumulation of junctions}
\usage{
sim_fin_chrom(
  pop_size = 100,
  freq_ancestor_1 = 0.5,
  total_runtime = 100,
  morgan = 1,
  seed = 42,
  R = 100
)
}
\arguments{
\item{pop_size}{Population Size}

\item{freq_ancestor_1}{Frequency of ancestor 1 at t = 0}

\item{total_runtime}{Maximum time after which the simulation is to be stopped}

\item{morgan}{Mean number of crossovers per meiosis (e.g. size in Morgan of
the chromosome)}

\item{seed}{Seed of the pseudo-random number generator}

\item{R}{Number of regularly distributed markers}
}
\value{
\item{avgJunctions}{vector of the average number of junctions at
time = [0, total_runtime]}
}
\description{
Individual based simulation of the accumulation of junctions
for a chromosome with regularly distributed markers.
}
\examples{
cat("example sim_fin_chrom")
sim_fin_chrom(pop_size = 100, freq_ancestor_1 = 0.5,
                   total_runtime = 10, morgan = 1, seed = 42,
                   R = 100)
}
