% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jubilee-macro-predict-method.R
\name{jubilee.macro_predict}
\alias{jubilee.macro_predict}
\title{Prediction from UNRATE and GDP models}
\usage{
jubilee.macro_predict(dtb, rs, new.tb3ms = NA, new.gs10 = NA)
}
\arguments{
\item{dtb}{data table, usually this is \code{lm.dtb} of the \code{rs} object,
with GDP log-return percent \code{(logrp.N, logrp.K)} calculated.}

\item{rs}{the list returned from \code{jubilee.macro_fit}, which provides
regression parameters for the prediction (not the data).}

\item{new.tb3ms}{numeric, vector of new \code{rate.tb3ms} with length equal to NROW of dtb.
Default is \code{NA}.}

\item{new.gs10}{numeric, vector of new \code{rate.gs10} with length equal to NROW of dtb.
Default is \code{NA}.}
}
\value{
The data table containing the predictions and all the required input columns
}
\description{
This utility performs the prediction from the linear models of UNRATE and GDP.
The purpose of this method is to automate the prediction and to allow users
experimenting optimization on the natural rate of interest.
}
\author{
Stephen H. Lihn
}
\keyword{data}
