% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_nice.R
\name{theme_nice}
\alias{theme_nice}
\title{A nice, flexible \code{ggplot2} theme}
\usage{
theme_nice(
  legend.pos = "right",
  style = c("white", "light", "dark_blue", "dark_gray"),
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)
}
\arguments{
\item{legend.pos}{One of \code{"right"}, \code{"left"}, \code{"top"}, \code{"bottom"} (outside
the plotting area), \code{"topleft"}, \code{"topright"}, \code{"topmiddle"},
\code{"bottomleft"}, \code{"bottomright"}, or \code{"bottommiddle"} (inside the plotting
area).}

\item{style}{One of \code{"white"}, \code{"light"}, \code{"dark_blue"}, or \code{"dark_gray"}.
\code{"white"} sets the background to white, \code{"light"} to light gray,
\code{"dark_gray"} to dark gray, \code{"dark_blue"} to dark blue.}

\item{base_size}{base font size, given in pts.}

\item{base_family}{base font family}

\item{base_line_size}{base size for line elements}

\item{base_rect_size}{base size for rect elements}
}
\description{
\code{theme_nice} is designed to work like any other complete theme from
\code{\link[ggplot2]{ggplot}}. It has a nice appearance.
}
\examples{
# Create plot with ggplot2
library(ggplot2)
plot <- ggplot(mpg, aes(cty, hwy)) +
  geom_jitter() + theme_nice()


}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
