% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_summ.R
\name{plot_summs}
\alias{plot_summs}
\alias{plot_coefs}
\title{Plot Regression Summaries}
\usage{
plot_summs(..., ci_level = 0.95, model.names = NULL, coefs = NULL,
  omit.coefs = "(Intercept)", inner_ci_level = NULL,
  color.class = "CUD Bright", plot.distributions = FALSE,
  rescale.distributions = FALSE, exp = FALSE, point.shape = TRUE,
  legend.title = "Model", groups = NULL, facet.rows = NULL,
  facet.cols = NULL, facet.label.pos = "top")

plot_coefs(..., ci_level = 0.95, inner_ci_level = NULL,
  model.names = NULL, coefs = NULL, omit.coefs = c("(Intercept)",
  "Intercept"), color.class = "CUD Bright", plot.distributions = FALSE,
  rescale.distributions = FALSE, exp = FALSE, point.shape = TRUE,
  legend.title = "Model", groups = NULL, facet.rows = NULL,
  facet.cols = NULL, facet.label.pos = "top")
}
\arguments{
\item{...}{regression model(s).}

\item{ci_level}{The desired width of confidence intervals for the
coefficients. Default: 0.95}

\item{model.names}{If plotting multiple models simultaneously, you can
provide a vector of names here. If NULL, they will be named sequentially
as "Model 1", "Model 2", and so on. Default: NULL}

\item{coefs}{If you'd like to include only certain coefficients, provide
them as a vector. If it is a named vector, then the names will be used
in place of the variable names. See details for examples. Default: NULL}

\item{omit.coefs}{If you'd like to specify some coefficients to not include
in the plot, provide them as a vector. This argument is overridden by
\code{coefs} if both are provided. By default, the intercept term is omitted.
To include the intercept term, just set omit.coefs to NULL.}

\item{inner_ci_level}{Plot a thicker line representing some narrower span
than \code{ci_level}. Default is NULL, but good options are .9, .8, or .5.}

\item{color.class}{See \link{jtools_colors} for more on your color options.
Default: 'CUD Bright'}

\item{plot.distributions}{Instead of just plotting the ranges, you may
plot normal distributions representing the width of each estimate. Note
that these are completely theoretical and not based on a bootstrapping
or MCMC procedure, even if the source model was fit that way. Default is
FALSE.}

\item{rescale.distributions}{If \code{plot.distributions} is TRUE, the default
behavior is to plot each normal density curve on the same scale. If some
of the uncertainty intervals are much wider/narrower than others, that
means the wide ones will have such a low height that you won't be able
to see the curve. If you set this parameter to TRUE, each curve will
have the same maximum height regardless of their width.}

\item{exp}{If TRUE, all coefficients are exponentiated (e.g., transforms
logit coefficents from log odds scale to odds). The reference line is
also moved to 1 instead of 0.}

\item{point.shape}{When using multiple models, should each model's point
estimates use a different point shape to visually differentiate each
model from the others? Default is TRUE.}

\item{legend.title}{What should the title for the legend be? Default is
"Model", but you can specify it here since it is rather difficult to
change later via \code{ggplot2}'s typical methods.}

\item{groups}{If you would like to have facets (i.e., separate panes) for
different groups of coefficients, you can specifiy those groups with a
list here. See details for more on how to do this.}

\item{facet.rows}{The number of rows in the facet grid (the \code{nrow} argument
to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}).}

\item{facet.cols}{The number of columns in the facet grid (the \code{nrow}
argument to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}).}

\item{facet.label.pos}{Where to put the facet labels. One of "top" (the
default), "bottom", "left", or "right".}
}
\value{
A ggplot object.
}
\description{
\code{plot_summs} and \code{plot_coefs} create regression coefficient
plots with ggplot2.
}
\details{
A note on the distinction between \code{plot_summs} and \code{plot_coefs}:
\code{plot_summs} only accepts models supported by \code{\link[=summ]{summ()}} and allows users
to take advantage of the standardization and robust standard error features
(among others as may be relevant). \code{plot_coefs} supports any models that
have a \code{\link[broom:tidy]{broom::tidy()}} method defined in the broom package, but of course
lacks any additional features like robust standard errors. To get a mix
of the two, you can pass \code{summ} objects to \code{plot_coefs} too.

For \code{coefs}, if you provide a named vector of coefficients, then
the plot will refer to the selected coefficients by the names of the
vector rather than the coefficient names. For instance, if I want to
include only the coefficients for the \code{hp} and \code{mpg} but have
the plot refer to them as "Horsepower" and "Miles/gallon", I'd provide
the argument like this:
\code{c("Horsepower" = "hp", "Miles/gallon" = "mpg")}

To use the \code{groups} argument, provide a (preferably named) list of
character vectors. If I want separate panes with "Frost" and "Illiteracy"
in one and "Population" and "Area" in the other, I'd make a list like
this:

\code{list(pane_1 = c("Frost", "Illiteracy"), pane_2 = c("Population", "Area"))}
}
\examples{
states <- as.data.frame(state.x77)
fit1 <- lm(Income ~ Frost + Illiteracy + Murder +
           Population + Area + `Life Exp` + `HS Grad`,
           data = states, weights = runif(50, 0.1, 3))
fit2 <- lm(Income ~ Frost + Illiteracy + Murder +
           Population + Area + `Life Exp` + `HS Grad`,
           data = states, weights = runif(50, 0.1, 3))
fit3 <- lm(Income ~ Frost + Illiteracy + Murder +
           Population + Area + `Life Exp` + `HS Grad`,
           data = states, weights = runif(50, 0.1, 3))

# Plot all 3 regressions with custom predictor labels,
# standardized coefficients, and robust standard errors
plot_summs(fit1, fit2, fit3,
           coefs = c("Frost Days" = "Frost", "\% Illiterate" = "Illiteracy",
                     "Murder Rate" = "Murder"),
           scale = TRUE, robust = TRUE)

}
