% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_utils.R
\name{probe_interaction}
\alias{probe_interaction}
\title{Probe interaction effects via simple slopes and plotting}
\usage{
probe_interaction(model, pred, modx, mod2 = NULL, ...)
}
\arguments{
\item{model}{A regression model of type \code{lm} or
\code{\link[survey]{svyglm}}.
It should contain the interaction of interest.}

\item{pred}{The predictor variable involved in the interaction.}

\item{modx}{The moderator variable involved in the interaction.}

\item{mod2}{Optional. The name of the second moderator
variable involved in the interaction.}

\item{...}{Other arguments accepted by \code{\link{sim_slopes}} and
\code{\link{interact_plot}}}
}
\value{
\item{simslopes}{The \code{sim_slopes} object created.}
\item{interactplot}{The \code{ggplot} object created by
\code{interact_plot}.}
}
\description{
\code{probe_interaction} is a convenience function that allows users to call
both \code{\link{sim_slopes}} and \code{\link{interact_plot}} with a single
call.
}
\details{
This function simply merges the nearly-equivalent arguments needed to call
both \code{\link{sim_slopes}} and \code{\link{interact_plot}} without the
need for re-typing their common arguments. Note that each function is called
separately and they re-fit a separate model for each level of each
moderator; therefore, the runtime may be considerably longer than the
original model fit. For larger models, this is worth keeping in mind.

Sometimes, you may want different parameters when doing simple slopes
analysis compared to when plotting interaction effects. For instance, it is
often easier to interpret the regression output when variables are
standardized; but plots are often easier to understand when the variables
are in their original units of measure.

\code{probe_interaction} does not
support providing different arguments to each function. If that is needed,
use \code{sim_slopes} and \code{interact_plot} directly.
}
\examples{

# Using a fitted model as formula input
fiti <- lm(Income ~ Frost + Murder * Illiteracy,
  data=as.data.frame(state.x77))
probe_interaction(model = fiti, pred = Murder, modx = Illiteracy,
                  modxvals = "plus-minus")
# 3-way interaction
fiti3 <- lm(Income ~ Frost * Murder * Illiteracy,
  data=as.data.frame(state.x77))
probe_interaction(model = fiti3, pred = Murder, modx = Illiteracy,
                  mod2 = Frost, mod2vals = "plus-minus")

# With svyglm
if (requireNamespace("survey")) {
library(survey)
data(api)
dstrat <- svydesign(id = ~1, strata = ~stype, weights = ~pw,
                    data = apistrat, fpc = ~fpc)
regmodel <- svyglm(api00 ~ ell * meals + sch.wide, design = dstrat)
probe_interaction(model = regmodel, pred = ell, modx = meals,
                  modxvals = "plus-minus", cond.int = TRUE)

# 3-way with survey and factor input
regmodel3 <- svyglm(api00 ~ ell * meals * sch.wide, design = dstrat)
probe_interaction(model = regmodel3, pred = ell, modx = meals,
                  mod2 = sch.wide)
# Can try different configurations of 1st vs 2nd mod
probe_interaction(model = regmodel3, pred = ell, modx = sch.wide,
                  mod2 = meals)
}

}
\seealso{
Other interaction tools: \code{\link{cat_plot}},
  \code{\link{interact_plot}},
  \code{\link{johnson_neyman}}, \code{\link{sim_slopes}}
}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
