## ----echo=FALSE----------------------------------------------------------
knitr::opts_chunk$set(message=F, warning=F)
library(jtools)

## ------------------------------------------------------------------------
# Fit model
fit <- lm(Income ~ Frost + Illiteracy + Murder, data = as.data.frame(state.x77))
summ(fit)

## ------------------------------------------------------------------------
summ(fit, model.info = FALSE, model.fit = FALSE)

## ------------------------------------------------------------------------
summ(fit, model.check = TRUE)

## ------------------------------------------------------------------------
summ(fit, robust = TRUE, robust.type = "HC3")

## ------------------------------------------------------------------------
summ(fit, standardize = TRUE)

## ------------------------------------------------------------------------
summ(fit, standardize = TRUE, n.sd = 2)

## ------------------------------------------------------------------------
summ(fit, center = TRUE)

## ------------------------------------------------------------------------
summ(fit, confint = TRUE, digits = 2)

## ------------------------------------------------------------------------
summ(fit, confint = TRUE, ci.width = .5, digits = 2)

## ------------------------------------------------------------------------
summ(fit, confint = TRUE, pvals = FALSE, digits = 2)

## ------------------------------------------------------------------------
fitg <- glm(vs ~ drat + mpg, data = mtcars, family = binomial)

summ(fitg)

## ------------------------------------------------------------------------
summ(fitg, odds.ratio = TRUE)

## ----message = FALSE, warning = FALSE------------------------------------
library(lme4)
fm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

summ(fm1)

## ------------------------------------------------------------------------
summ(fit, model.info = FALSE, digits = 5)

## ------------------------------------------------------------------------
summ(fit, model.info = FALSE, digits = 1)

## ------------------------------------------------------------------------
options("jtools-digits" = 2)
summ(fit, model.info = FALSE)

## ----echo = F------------------------------------------------------------
options("jtools-digits" = NULL)

## ------------------------------------------------------------------------
j <- summ(fit, digits = 3)

j$coeftable

## ------------------------------------------------------------------------
summ(fit, vifs = TRUE)

