% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_compile.R
\name{compile}
\alias{compile}
\alias{compile.cpt_list}
\alias{compile.pot_list}
\title{Compile information}
\usage{
compile(
  x,
  evidence = NULL,
  root_node = "",
  joint_vars = NULL,
  tri = "min_fill",
  pmf_evidence = NULL,
  alpha = NULL
)

\method{compile}{cpt_list}(
  x,
  evidence = NULL,
  root_node = "",
  joint_vars = NULL,
  tri = "min_fill",
  pmf_evidence = NULL,
  alpha = NULL
)

\method{compile}{pot_list}(
  x,
  evidence = NULL,
  root_node = "",
  joint_vars = NULL,
  tri = "min_fill",
  pmf_evidence = NULL,
  alpha = NULL
)
}
\arguments{
\item{x}{An object returned from \code{cpt_list} (baeysian network) or
\code{pot_list} (decomposable markov random field)}

\item{evidence}{A named vector. The names are the variabes and the elements
are the evidence.}

\item{root_node}{A node for which we require it to live in the root
clique (the first clique).}

\item{joint_vars}{A vector of variables for which we require them
to be in the same clique. Edges between all these variables are added
to the moralized graph.}

\item{tri}{The optimization strategy used for triangulation if x originates
from a Baeysian network. One of
\itemize{
\item 'min_fill'
\item 'min_rfill'
\item 'min_efill'
\item 'min_sfill'
\item 'min_sp'
\item 'min_esp'
\item 'min_nei'
\item 'minimal'
\item 'alpha'
}}

\item{pmf_evidence}{A named vector of frequencies. The names should
correspond to the evidence that is expected to see over time. Relevant
in connection to \code{min_efill} and \code{min_esp} triangulations.}

\item{alpha}{Character vector. A permutation of the nodes
in the graph. It specifies a user-supplied eliminination ordering for
triangulation of the moral graph.}
}
\description{
Compiled objects are used as building blocks for junction tree inference
}
\details{
The Junction Tree Algorithm performs both a forward and inward
message pass (collect and distribute). However, when the forward
phase is finished, the root clique potential is guaranteed to be the
joint pmf over the variables involved in the root clique. Thus, if
it is known in advance that a specific variable is of interest, the
algortihm can be terminated after the forward phase. Use the \code{root_node}
to specify such a variable and specify \code{propagate = "collect"} in
the juntion tree algortihm function \code{jt}.

Moreover, if interest is in some joint pmf for variables that end up
being in different cliques these variables must be specified in advance
using the \code{joint_vars} argument. The compilation step then
adds edges between all of these variables to ensure that at least one
clique contains all of them.

Evidence can be entered either at compile stage
or after compilation. Hence, one can also combine
evidence from before compilation with evidence
after compilation. Before refers to entering
evidence in the 'compile' function and after
refers to entering evidence in the 'jt' function.

Finally, one can either use a Bayesian network or a decomposable
Markov random field (use the \code{ess} package to fit these). Bayesian
networks must be constructed with \code{cpt_list} and decomposable MRFs
should be constructed with \code{pot_list}, but can also be constructed
using \code{cpt_list}.
}
\examples{
cptl <- cpt_list(asia2)
cp1  <- compile(cptl, evidence = c(bronc = "yes"), joint_vars = c("bronc", "tub"))
print(cp1)
names(cp1)
dim_names(cp1)
plot(get_graph(cp1))
}
