% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_spec.R
\name{jst_define_import}
\alias{jst_define_import}
\title{Define an import specification}
\usage{
jst_define_import(...)
}
\arguments{
\item{...}{Named arguments with bare function names.}
}
\value{
A specification of imports which is necessary for
\code{\link[=jst_import_zip]{jst_import_zip()}}.
}
\description{
Define which parts of a zip file should be converted via which functions.
}
\details{
The function accepts the following names: article, book, report, pamphlet,
ngram1, ngram2, ngram3.
The corresponding files from a .zip-archive will be imported via the supplied
functions.
}
\examples{
# articles will be imported via `jst_get_article()` and `jst_get_authors()`
jst_define_import(article = c(jst_get_article, jst_get_authors))

# define a specification for importing article metadata and unigrams (ngram1)
jst_define_import(article = jst_get_article,
                  ngram1 = jst_get_ngram)
                  
                  
# import all four types with one function each
jst_define_import(article = jst_get_article,
                  book = jst_get_book,
                  report = jst_get_book,
                  pamphlet = jst_get_article)
                  
# import all four types with multiple functions
jst_define_import(article = c(jst_get_article, jst_get_authors, jst_get_references),
                  book = c(jst_get_book, jst_get_chapters),
                  report = jst_get_book,
                  pamphlet = jst_get_article)

# if you want to import chapters with authors, you can use an anonymous
# function

chapters_w_authors <- function(x) jst_get_chapters(x, authors = TRUE)
jst_define_import(book = chapters_w_authors)


\dontrun{
# define imports
imports <- jst_define_import(article = c(jst_get_article, jst_get_authors))

# convert the files to .csv
jst_import_zip("my_archive.zip", out_file = "my_out_file", 
                 import_spec = imports)
}
}
