% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar.R
\name{barServer}
\alias{barServer}
\title{barServer: shiny module server for barplot.}
\usage{
barServer(id, data, data_label, data_varStruct = NULL, nfactor.limit = 10)
}
\arguments{
\item{id}{id}

\item{data}{Reactive data}

\item{data_label}{Reactive data label}

\item{data_varStruct}{Reactive List of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit in factor variable, Default: 10}
}
\value{
Shiny module server for barplot.
}
\description{
Shiny module server for barplot.
}
\details{
Shiny module server for barplot.
}
\examples{
library(shiny);library(ggplot2);library(ggpubr);
ui <- fluidPage(
   sidebarLayout(
   sidebarPanel(
     barUI("bar")
   ),
   mainPanel(
     plotOutput("bar_plot"),
     ggplotdownUI("bar")
   )
 )
)

server <- function(input, output, session) {

  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_bar <- barServer("bar", data = data, data_label = data.label,
    data_varStruct = NULL)

  output$bar_plot <- renderPlot({
    print(out_bar())
  })
}
}
