\name{qdiag}
\alias{qdiag}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Joint Approximate Diagonalization of a set of square, symmetric
and real-valued matrices}
\description{
  This function performs a Joint Approximate Diagonalization of a set of
square, symmetric and real-valued matrices. 
}
\usage{
qdiag(C, W0 = NULL, eps = .Machine$double.eps, itermax = 200, keepTrace = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{C}{DOUBLE ARRAY (KxKxN). Three-dimensional array with dimensions 
KxKxN representing the set
of square, symmetric and real-valued matrices to be jointly diagonalized. 
N is the number of matrices. Matrices
are KxK square matrices.}
  \item{W0}{DOUBLE MATRIX (KxK). The initial guess of a joint 
diagonalizer. If NULL, an initial
guess is automatically generated by the algorithm.}
  \item{eps}{DOUBLE. The algorithm stops when the criterium difference 
between two
iterations is less than eps.}
  \item{itermax}{INTEGER. Alternatively, the algorithm stops when itermax 
sweeps have
been performed without reaching convergence. If the maximum number of
iteration is performed, a warning appears.}
  \item{keepTrace}{BOOLEAN. Do we want to keep the successive estimations of 
the joint diagonalizer.}
}
\details{
  Given a set \eqn{C_i} of N KxK symmetric and real-valued matrices, the
algorithm is looking for a matrix \eqn{B} such that
\eqn{\forall i \in [1,N]}, \eqn{B C_i B^T} is as close as possible of a
diagonal matrix. 
}
\value{
  \item{B}{Estimation of the Joint Diagonalizer.}
  \item{criter}{Successive estimates of the cost function across sweeps.}
  \item{B_trace}{Array of the successive estimates of B across iterations.}
}
\note{
Two versions of the quadratic optimization are present in the paper
referenced below. These two
versions have different complexities, \code{O(N K^3)} and \code{O(K^5)}.
Currently only the version with \code{O(N K^3)} is implemented.
}
\references{R. Vollgraf and K. Obermayer; Quadratic Optimization for
Approximate Matrix Diagonalization; IEEE Transaction on Signal Processing, 
2006}
\author{Cedric Gouy-Pailler (cedric.gouypailler@gmail.com), 
from the initial matlab code by R. Vollgraf.}
\examples{
# generating diagonal matrices
D <- replicate(30, diag(rchisq(df=1,n=10)), simplify=FALSE)
# Mixing and demixing matrices
B <- matrix(rnorm(100),10,10)
A <- solve(B)
C <- array(NA,dim=c(10,10,30))
for (i in 1:30) C[,,i] <- A \%*\% D[[i]] \%*\% t(A)
B_est <- qdiag(C)$B
# B_est should be an approximate of B=solve(A)
B_est \%*\% A
# close to a permutation matrix (with random scales)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{algebra}


