% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longst.R
\name{longst}
\alias{longst}
\title{Function for longitudinal starting values}
\usage{
longst(longdat, long.formula.orig, long.rand.ind, long.rand.stud = NULL,
  longdat2, id.name, study.name, studies)
}
\arguments{
\item{longdat}{the longitudinal data with factors and interaction terms
expanded, ordered by increasing survival time}

\item{long.formula.orig}{the original longitudinal formula as supplied to the
function call}

\item{long.rand.ind}{a vector of character strings to indicate what variables
to assign individual level random effects to.  A maximum of three
individual level random effects can be assigned.  To assign a random
intercept include 'int' in the vector.  To not include an individual level
random intercept include 'noint' in the vector.  For example to fit a model
with individual level random intercept and random slope set
\code{long.rand.ind = c('int', 'time')}, where \code{'time'} is the
longitudinal time variable in the \code{data}.}

\item{long.rand.stud}{a vector of character strings to indicate what
variables to assign study level random effects to.  If no study level
random effects then this either not specified in function call or set to
\code{NULL}.  If a study level random intercept is required, include the
name of the study membership variable for example \code{long.rand.stud =
'study'}.}

\item{longdat2}{the longitudinal dataset, without factors expanded into dummy
variables, ordered by increasing survival time}

\item{id.name}{character string specifying the id variable in the dataset}

\item{study.name}{a character string denoting the name of the variable in the
baseline dataset in \code{data} holding study membership, for example
\code{study.name = 'study'}.}

\item{studies}{the names of the studies present in the supplied data}
}
\value{
A list of results from the separate longitudinal fit is returned. The
  elements of this list are: \describe{

  \item{\code{beta1}}{a data frame containing the estimates of the fixed
  effects from the longitudinal sub-model}

  \item{\code{sigma.e}}{the estimate of the variance for the measurement
  error variance for the longitudinal model}

  \item{\code{D}}{a data frame containing the estimate of the covariance
  matrix for the individual level random effects}

  \item{\code{log.like.long}}{the log-likelihood for the separate
  longitudinal model}

  \item{\code{randstart.ind}}{the conditional modes of the individual level
  random effects given the data and the parameter estimates from the separate
  longitudinal model. The data frame has number of columns equal to the
  number of individual level random effects, and the number of rows equal to
  the number of individuals in the dataset}

  \item{\code{randstart.ind.cov}}{a list of the conditional covariance
  matrices for each individual for the individual level random effects. The
  list is of length equal to the number of individuals in the dataset. Each
  element of the list is a matrix of dimensions equal to the number of study
  level random effects in the model.}

  \item{\code{A}}{a data frame containing the estimate of the covariance
  matrix for the study level random effects.  This is present in the results
  only if study level random effects are included in the model.}

  \item{\code{randstart.stud}}{the conditional modes of the study level
  random effects given the data and the parameter estimates from the separate
  longitudinal model.  The data frame has number of columns equal to the
  number of study level random effects, and number of rows equal to the
  number of studies in the dataset.  This is present in the results only if
  study level random effects are included in the model.}

  \item{\code{randstart.stud.cov}}{a list of the conditional covariance
  matrices for each study for the study level random effects. The list is of
  length equal to the number of studies in the dataset. Each element of the
  list is a matrix of dimensions equal to the number of study level random
  effects in the model.  This is present in the results only if study level
  random effects are included in the model.}

  \item{\code{modelfit}}{the initial longitudinal model fit, fitted using the
  \code{\link[lme4]{lmer}} function}

  }
}
\description{
Internal function to estimate the starting values for the EM algorithm for
the longitudinal sub-model
}
\keyword{internal}
