% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.mjoint.R
\name{residuals.mjoint}
\alias{residuals.mjoint}
\title{Extract \code{mjoint} residuals}
\usage{
\method{residuals}{mjoint}(object, level = 0, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{mjoint} for a joint model
of time-to-event and multivariate longitudinal data.}

\item{level}{an optional integer giving the level of grouping to be used in
extracting the residuals from object. Level values increase from outermost
to innermost grouping, with level 0 corresponding to the population
residuals and level 1 corresponding to subject-specific residuals. Defaults
to level 0.}

\item{...}{additional arguments; currently none are used.}
}
\value{
A \code{list} of length \eqn{K} with each element a vector of
  residuals for the \eqn{k}-th longitudinal outcome.
}
\description{
The residuals at level \emph{i} are obtained by subtracting the fitted
  levels at that level from the response vector.
}
\references{
Pinheiro JC, Bates DM. \emph{Mixed-Effects Models in S and S-PLUS.} New York:
Springer Verlag; 2000.
}
\seealso{
\code{\link{mjoint}}, \code{\link{fitted.mjoint}}
}
\author{
Graeme L. Hickey (\email{graeme.hickey@liverpool.ac.uk})
}
\keyword{methods}
