% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointplot.R
\name{jointplot}
\alias{jointplot}
\title{Joint plot of longitudinal and survival data}
\usage{
jointplot(object, Y.col, Cens.col, lag, split = TRUE, col1, col2, xlab, ylab,
  gp1lab, gp2lab, smooth = 2/3, mean.profile = FALSE, mcol1, mcol2)
}
\arguments{
\item{object}{an object of class \code{jointdata}.}

\item{Y.col}{an element of class \code{character} identifying the 
longitudinal response part of the \code{jointdata} object.}

\item{Cens.col}{an element of class \code{character} identifying the survival
status or censoring indicator part of the \code{jointdata} object.}

\item{lag}{argument which specifies how many units in time we look back 
through. Defaults to the maximum observation time across all units.}

\item{split}{logical argument which allows the profiles of units which 
\emph{fail} and those which are \emph{censored} to be viewed in separate 
panels of the same graph. This is the default option. Using \code{split =
FALSE} will plot all profiles overlaid on a single plot.}

\item{col1}{argument to choose the colour for the profiles of the 
\emph{censored} units.}

\item{col2}{argument to choose the colour for the profiles of the 
\emph{failed} units.}

\item{xlab}{an element of class \code{character} indicating the title for the
x-axis.}

\item{ylab}{an element of class \code{character} indicating the title for the
x-axis.}

\item{gp1lab}{an element of class \code{character} for the group 
corresponding to a censoring indicator of zero. Typically, the censored 
group.}

\item{gp2lab}{an element of class \code{character} for the group 
corresponding to a censoring indicator of one. Typically, the group 
experiencing the event of interest.}

\item{smooth}{the smoother span. This gives the proportion of points in the 
plot which influence the smooth at each value. Defaults to a value of 2/3. 
Larger values give more smoothness. See \code{\link[stats]{lowess}} for 
further details.}

\item{mean.profile}{draw mean profiles if TRUE. Only applies to the 
\code{split = TRUE} case.}

\item{mcol1}{argument to choose the colour for the mean profile of the units 
with a censoring indicator of zero.}

\item{mcol2}{argument to choose the colour for the mean profile of the units 
with a censoring indicator of one.}
}
\value{
A lattice plot.
}
\description{
This function views the longitudinal profile of each unit with
  the last longitudinal measurement prior to event-time (censored or not)
  taken as the end-point, referred to as time zero. In doing so, the shape of
  the profile prior to event-time can be inspected. This can be done over a
  user-specified number of time units.
}
\details{
The function tailors the \code{\link[lattice]{xyplot}} function to 
  produce a representation of joint data with longitudinal and survival 
  components.
}
\note{
If more than one cause of failure is present (i.e. competing risks
  data), then all failures are pooled together into a single failure type.
}
\examples{
data(heart.valve)
heart.surv <- UniqueVariables(heart.valve, 
                              var.col = c("fuyrs", "status"),
                              id.col = "num")
heart.long <- heart.valve[, c("num", "time", "log.lvmi")]
heart.cov <- UniqueVariables(heart.valve, 
                             c("age", "sex"), 
                             id.col = "num")
heart.valve.jd <- jointdata(longitudinal = heart.long, 
                            baseline = heart.cov, 
                            survival = heart.surv,
                            id.col = "num",
                            time.col = "time")
jointplot(heart.valve.jd, Y.col = "log.lvmi", 
          Cens.col = "status", lag = 5)
}
\references{
Wulfsohn MS, Tsiatis AA. A joint model for survival and longitudinal data 
measured with error. \emph{Biometrics.} 1997; \strong{53(1)}: 330-339.
}
\seealso{
\code{\link[lattice]{xyplot}}, \code{\link{joint}}, 
  \code{\link{jointdata}}.
}
\author{
Pete Philipson (\email{pete.philipson@northumbria.ac.uk})
}
\keyword{dplot}
