
# This file is automatically generated, you probably don't want to edit this

ttestISOptions <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "ttestISOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            group = NULL,
            students = TRUE,
            bf = FALSE,
            bfPrior = 0.707,
            welchs = FALSE,
            mann = FALSE,
            hypothesis = "different",
            norm = FALSE,
            qq = FALSE,
            eqv = FALSE,
            meanDiff = FALSE,
            ci = FALSE,
            ciWidth = 95,
            effectSize = FALSE,
            ciES = FALSE,
            ciWidthES = 95,
            desc = FALSE,
            plots = FALSE,
            miss = "perAnalysis", ...) {

            super$initialize(
                package="jmv",
                name="ttestIS",
                requiresData=TRUE,
                ...)

            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"),
                rejectInf=FALSE)
            private$..group <- jmvcore::OptionVariable$new(
                "group",
                group,
                suggested=list(
                    "nominal",
                    "ordinal"),
                permitted=list(
                    "factor"))
            private$..students <- jmvcore::OptionBool$new(
                "students",
                students,
                default=TRUE)
            private$..bf <- jmvcore::OptionBool$new(
                "bf",
                bf,
                default=FALSE)
            private$..bfPrior <- jmvcore::OptionNumber$new(
                "bfPrior",
                bfPrior,
                default=0.707,
                min=0.01,
                max=2)
            private$..welchs <- jmvcore::OptionBool$new(
                "welchs",
                welchs,
                default=FALSE)
            private$..mann <- jmvcore::OptionBool$new(
                "mann",
                mann,
                default=FALSE)
            private$..hypothesis <- jmvcore::OptionList$new(
                "hypothesis",
                hypothesis,
                options=list(
                    "different",
                    "oneGreater",
                    "twoGreater"),
                default="different")
            private$..norm <- jmvcore::OptionBool$new(
                "norm",
                norm,
                default=FALSE)
            private$..qq <- jmvcore::OptionBool$new(
                "qq",
                qq,
                default=FALSE)
            private$..eqv <- jmvcore::OptionBool$new(
                "eqv",
                eqv,
                default=FALSE)
            private$..meanDiff <- jmvcore::OptionBool$new(
                "meanDiff",
                meanDiff,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..effectSize <- jmvcore::OptionBool$new(
                "effectSize",
                effectSize,
                default=FALSE)
            private$..ciES <- jmvcore::OptionBool$new(
                "ciES",
                ciES,
                default=FALSE)
            private$..ciWidthES <- jmvcore::OptionNumber$new(
                "ciWidthES",
                ciWidthES,
                min=50,
                max=99.9,
                default=95)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
            private$..miss <- jmvcore::OptionList$new(
                "miss",
                miss,
                options=list(
                    "perAnalysis",
                    "listwise"),
                default="perAnalysis")

            self$.addOption(private$..vars)
            self$.addOption(private$..group)
            self$.addOption(private$..students)
            self$.addOption(private$..bf)
            self$.addOption(private$..bfPrior)
            self$.addOption(private$..welchs)
            self$.addOption(private$..mann)
            self$.addOption(private$..hypothesis)
            self$.addOption(private$..norm)
            self$.addOption(private$..qq)
            self$.addOption(private$..eqv)
            self$.addOption(private$..meanDiff)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..effectSize)
            self$.addOption(private$..ciES)
            self$.addOption(private$..ciWidthES)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
            self$.addOption(private$..miss)
        }),
    active = list(
        vars = function() private$..vars$value,
        group = function() private$..group$value,
        students = function() private$..students$value,
        bf = function() private$..bf$value,
        bfPrior = function() private$..bfPrior$value,
        welchs = function() private$..welchs$value,
        mann = function() private$..mann$value,
        hypothesis = function() private$..hypothesis$value,
        norm = function() private$..norm$value,
        qq = function() private$..qq$value,
        eqv = function() private$..eqv$value,
        meanDiff = function() private$..meanDiff$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value,
        effectSize = function() private$..effectSize$value,
        ciES = function() private$..ciES$value,
        ciWidthES = function() private$..ciWidthES$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value,
        miss = function() private$..miss$value),
    private = list(
        ..vars = NA,
        ..group = NA,
        ..students = NA,
        ..bf = NA,
        ..bfPrior = NA,
        ..welchs = NA,
        ..mann = NA,
        ..hypothesis = NA,
        ..norm = NA,
        ..qq = NA,
        ..eqv = NA,
        ..meanDiff = NA,
        ..ci = NA,
        ..ciWidth = NA,
        ..effectSize = NA,
        ..ciES = NA,
        ..ciWidthES = NA,
        ..desc = NA,
        ..plots = NA,
        ..miss = NA)
)

ttestISResults <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "ttestISResults",
    inherit = jmvcore::Group,
    active = list(
        ttest = function() private$.items[["ttest"]],
        assum = function() private$.items[["assum"]],
        desc = function() private$.items[["desc"]],
        plots = function() private$.items[["plots"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Independent Samples T-Test")
            self$add(jmvcore::Table$new(
                options=options,
                name="ttest",
                title="Independent Samples T-Test",
                rows="(vars)",
                clearWith=list(
                    "group",
                    "hypothesis",
                    "ciWidth",
                    "miss",
                    "bfPrior",
                    "ciWidthES"),
                columns=list(
                    list(
                        `name`="var[stud]", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(students)"),
                    list(
                        `name`="name[stud]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Student's t", 
                        `visible`="(students)"),
                    list(
                        `name`="stat[stud]", 
                        `title`="Statistic", 
                        `type`="number", 
                        `visible`="(students)"),
                    list(
                        `name`="err[stud]", 
                        `title`="error %", 
                        `type`="number", 
                        `visible`="(students && bf)", 
                        `content`=""),
                    list(
                        `name`="df[stud]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(students)"),
                    list(
                        `name`="p[stud]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(students)"),
                    list(
                        `name`="md[stud]", 
                        `title`="Mean difference", 
                        `type`="number", 
                        `visible`="(meanDiff && students)"),
                    list(
                        `name`="sed[stud]", 
                        `title`="SE difference", 
                        `type`="number", 
                        `visible`="(meanDiff && students)"),
                    list(
                        `name`="cil[stud]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && students)"),
                    list(
                        `name`="ciu[stud]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && students)"),
                    list(
                        `name`="esType[stud]", 
                        `title`="", 
                        `content`="Cohen's d", 
                        `type`="text", 
                        `visible`="(effectSize && students)"),
                    list(
                        `name`="es[stud]", 
                        `title`="Effect Size", 
                        `type`="number", 
                        `visible`="(effectSize && students)"),
                    list(
                        `name`="ciles[stud]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && students)"),
                    list(
                        `name`="ciues[stud]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && students)"),
                    list(
                        `name`="var[bf]", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(bf)"),
                    list(
                        `name`="name[bf]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Bayes factor\u2081\u2080", 
                        `visible`="(bf)"),
                    list(
                        `name`="stat[bf]", 
                        `title`="Statistic", 
                        `type`="number", 
                        `visible`="(bf)", 
                        `refs`=list(
                            "BF",
                            "btt")),
                    list(
                        `name`="err[bf]", 
                        `title`="\u00B1%", 
                        `type`="number", 
                        `visible`="(bf)"),
                    list(
                        `name`="df[bf]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(bf)", 
                        `content`=""),
                    list(
                        `name`="p[bf]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(bf)", 
                        `content`=""),
                    list(
                        `name`="md[bf]", 
                        `title`="Mean difference", 
                        `type`="number", 
                        `visible`="(meanDiff && bf)", 
                        `content`=""),
                    list(
                        `name`="sed[bf]", 
                        `title`="SE difference", 
                        `type`="number", 
                        `visible`="(meanDiff && bf)", 
                        `content`=""),
                    list(
                        `name`="cil[bf]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && bf)", 
                        `content`=""),
                    list(
                        `name`="ciu[bf]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && bf)", 
                        `content`=""),
                    list(
                        `name`="esType[bf]", 
                        `title`="", 
                        `content`="", 
                        `type`="text", 
                        `visible`="(effectSize && bf)"),
                    list(
                        `name`="es[bf]", 
                        `title`="Effect Size", 
                        `type`="number", 
                        `visible`="(effectSize && bf)", 
                        `content`=""),
                    list(
                        `name`="ciles[bf]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && bf)", 
                        `content`=""),
                    list(
                        `name`="ciues[bf]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && bf)", 
                        `content`=""),
                    list(
                        `name`="var[welc]", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(welchs)"),
                    list(
                        `name`="name[welc]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Welch's t", 
                        `visible`="(welchs)"),
                    list(
                        `name`="stat[welc]", 
                        `title`="Statistic", 
                        `visible`="(welchs)"),
                    list(
                        `name`="err[welc]", 
                        `title`="\u00B1%", 
                        `type`="number", 
                        `visible`="(welchs && bf)", 
                        `content`=""),
                    list(
                        `name`="df[welc]", 
                        `title`="df", 
                        `type`="number", 
                        `visible`="(welchs)"),
                    list(
                        `name`="p[welc]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(welchs)"),
                    list(
                        `name`="md[welc]", 
                        `title`="Mean difference", 
                        `type`="number", 
                        `visible`="(meanDiff && welchs)"),
                    list(
                        `name`="sed[welc]", 
                        `title`="SE difference", 
                        `type`="number", 
                        `visible`="(meanDiff && welchs)"),
                    list(
                        `name`="cil[welc]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && welchs)"),
                    list(
                        `name`="ciu[welc]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && welchs)"),
                    list(
                        `name`="esType[welc]", 
                        `title`="", 
                        `content`="Cohen's d", 
                        `type`="text", 
                        `visible`="(effectSize && welchs)"),
                    list(
                        `name`="es[welc]", 
                        `title`="Effect Size", 
                        `type`="number", 
                        `visible`="(effectSize && welchs)"),
                    list(
                        `name`="ciles[welc]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && welchs)"),
                    list(
                        `name`="ciues[welc]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && welchs)"),
                    list(
                        `name`="var[mann]", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(mann)"),
                    list(
                        `name`="name[mann]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Mann-Whitney U", 
                        `visible`="(mann)"),
                    list(
                        `name`="stat[mann]", 
                        `title`="Statistic", 
                        `content`=".", 
                        `visible`="(mann)"),
                    list(
                        `name`="err[mann]", 
                        `title`="\u00B1%", 
                        `type`="number", 
                        `visible`="(mann && bf)", 
                        `content`=""),
                    list(
                        `name`="p[mann]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(mann)"),
                    list(
                        `name`="md[mann]", 
                        `title`="Mean difference", 
                        `type`="number", 
                        `visible`="(meanDiff && mann)"),
                    list(
                        `name`="sed[mann]", 
                        `title`="SE difference", 
                        `type`="number", 
                        `visible`="(meanDiff && mann)"),
                    list(
                        `name`="cil[mann]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && mann)"),
                    list(
                        `name`="ciu[mann]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci && meanDiff && mann)"),
                    list(
                        `name`="esType[mann]", 
                        `title`="", 
                        `content`="Rank biserial correlation", 
                        `type`="text", 
                        `visible`="(effectSize && mann)", 
                        `refs`="Kerby2014"),
                    list(
                        `name`="es[mann]", 
                        `title`="Effect Size", 
                        `type`="number", 
                        `visible`="(effectSize && mann)"),
                    list(
                        `name`="ciles[mann]", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && mann)"),
                    list(
                        `name`="ciues[mann]", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ciES && effectSize && mann)"))))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    norm = function() private$.items[["norm"]],
                    eqv = function() private$.items[["eqv"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="assum",
                            title="Assumptions")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="norm",
                            title="Normality Test (Shapiro-Wilk)",
                            visible="(norm)",
                            rows="(vars)",
                            clearWith=list(
                                "miss",
                                "group"),
                            notes=list(
                                `p`="A low p-value suggests a violation of the assumption of normality"),
                            columns=list(
                                list(
                                    `name`="name", 
                                    `title`="", 
                                    `content`="($key)", 
                                    `type`="text"),
                                list(
                                    `name`="w", 
                                    `title`="W", 
                                    `type`="number"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue"))))
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="eqv",
                            title="Homogeneity of Variances Test (Levene's)",
                            visible="(eqv)",
                            rows="(vars)",
                            clearWith=list(
                                "group",
                                "miss"),
                            notes=list(
                                `p`="A low p-value suggests a violation of the assumption of equal variances"),
                            refs="car",
                            columns=list(
                                list(
                                    `name`="name", 
                                    `title`="", 
                                    `content`="($key)", 
                                    `type`="text"),
                                list(
                                    `name`="f", 
                                    `title`="F", 
                                    `type`="number"),
                                list(
                                    `name`="df", 
                                    `type`="number"),
                                list(
                                    `name`="df2", 
                                    `type`="number"),
                                list(
                                    `name`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue"))))}))$new(options=options))
            self$add(jmvcore::Table$new(
                options=options,
                name="desc",
                title="Group Descriptives",
                visible="(desc)",
                rows="(vars)",
                clearWith=list(
                    "group",
                    "miss"),
                columns=list(
                    list(
                        `name`="dep", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text"),
                    list(
                        `name`="group[1]", 
                        `title`="Group", 
                        `type`="text"),
                    list(
                        `name`="num[1]", 
                        `title`="N", 
                        `type`="integer"),
                    list(
                        `name`="mean[1]", 
                        `title`="Mean", 
                        `type`="number"),
                    list(
                        `name`="med[1]", 
                        `title`="Median", 
                        `type`="number"),
                    list(
                        `name`="sd[1]", 
                        `title`="SD", 
                        `type`="number"),
                    list(
                        `name`="se[1]", 
                        `title`="SE", 
                        `type`="number"),
                    list(
                        `name`="group[2]", 
                        `title`="Group", 
                        `type`="text"),
                    list(
                        `name`="num[2]", 
                        `title`="N", 
                        `type`="integer"),
                    list(
                        `name`="mean[2]", 
                        `title`="Mean", 
                        `type`="number"),
                    list(
                        `name`="med[2]", 
                        `title`="Median", 
                        `type`="number"),
                    list(
                        `name`="sd[2]", 
                        `title`="SD", 
                        `type`="number"),
                    list(
                        `name`="se[2]", 
                        `title`="SE", 
                        `type`="number"))))
            self$add(jmvcore::Array$new(
                options=options,
                name="plots",
                title="Plots",
                items="(vars)",
                clearWith=list(
                    "group",
                    "miss"),
                template=R6::R6Class(
                    inherit = jmvcore::Group,
                    active = list(
                        desc = function() private$.items[["desc"]],
                        qq = function() private$.items[["qq"]]),
                    private = list(),
                    public=list(
                        initialize=function(options) {
                            super$initialize(
                                options=options,
                                name="undefined",
                                title="$key")
                            self$add(jmvcore::Image$new(
                                options=options,
                                name="desc",
                                visible="(plots)",
                                renderFun=".desc",
                                clearWith=list()))
                            self$add(jmvcore::Image$new(
                                options=options,
                                name="qq",
                                width=350,
                                height=300,
                                requiresData=TRUE,
                                visible="(qq)",
                                renderFun=".qq",
                                clearWith=list()))}))$new(options=options)))}))

ttestISBase <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "ttestISBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = "jmv",
                name = "ttestIS",
                version = c(1,0,0),
                options = options,
                results = ttestISResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE,
                requiresMissings = FALSE,
                weightsSupport = 'auto')
        }))

#' Independent Samples T-Test
#'
#' The Student's Independent samples t-test (sometimes called a two-samples
#' t-test) is used to test the null hypothesis that two groups have the
#' same mean. A low p-value suggests that the null hypothesis is not true,
#' and therefore the group means are different.
#' 
#' The Student's independent t-test assumes that the data from each group
#' are from a normal distribution, and that the variances of these groups
#' are equal. If unwilling to assume the groups have equal variances, the
#' Welch's t-test can be used in it's place. If one is additionally
#' unwilling to assume the data from each group are from a normal
#' distribution, the non-parametric Mann-Whitney U test can be used instead
#' (However, note that the Mann-Whitney U test has a slightly different
#' null hypothesis; that the distributions of each group is equal).
#' 
#'
#' @examples
#' data('ToothGrowth')
#'
#' ttestIS(formula = len ~ supp, data = ToothGrowth)
#'
#' #
#' #  INDEPENDENT SAMPLES T-TEST
#' #
#' #  Independent Samples T-Test
#' #  ----------------------------------------------------
#' #                          statistic    df      p
#' #  ----------------------------------------------------
#' #    len    Student's t         1.92    58.0    0.060
#' #  ----------------------------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param vars the dependent variables (not necessary when using a formula,
#'   see the examples)
#' @param group the grouping variable with two levels (not necessary when
#'   using a formula, see the examples)
#' @param students \code{TRUE} (default) or \code{FALSE}, perform Student's
#'   t-tests
#' @param bf \code{TRUE} or \code{FALSE} (default), provide Bayes factors
#' @param bfPrior a number between 0.01 and 2 (default 0.707), the prior width
#'   to use in calculating Bayes factors
#' @param welchs \code{TRUE} or \code{FALSE} (default), perform Welch's
#'   t-tests
#' @param mann \code{TRUE} or \code{FALSE} (default), perform Mann-Whitney U
#'   tests
#' @param hypothesis \code{'different'} (default), \code{'oneGreater'} or
#'   \code{'twoGreater'}, the alternative hypothesis; group 1 different to group
#'   2, group 1 greater than group 2, and group 2 greater than group 1
#'   respectively
#' @param norm \code{TRUE} or \code{FALSE} (default), perform Shapiro-Wilk
#'   tests of normality
#' @param qq \code{TRUE} or \code{FALSE} (default), provide Q-Q plots of
#'   residuals
#' @param eqv \code{TRUE} or \code{FALSE} (default), perform Levene's tests
#'   for homogeneity of variances
#' @param meanDiff \code{TRUE} or \code{FALSE} (default), provide means and
#'   standard errors
#' @param ci \code{TRUE} or \code{FALSE} (default), provide confidence
#'   intervals
#' @param ciWidth a number between 50 and 99.9 (default: 95), the width of
#'   confidence intervals
#' @param effectSize \code{TRUE} or \code{FALSE} (default), provide effect
#'   sizes
#' @param ciES \code{TRUE} or \code{FALSE} (default), provide confidence
#'   intervals for the effect-sizes
#' @param ciWidthES a number between 50 and 99.9 (default: 95), the width of
#'   confidence intervals for the effect sizes
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   statistics
#' @param plots \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   plots
#' @param miss \code{'perAnalysis'} or \code{'listwise'}, how to handle
#'   missing values; \code{'perAnalysis'} excludes missing values for individual
#'   dependent variables, \code{'listwise'} excludes a row from all analyses if
#'   one of its entries is missing.
#' @param formula (optional) the formula to use, see the examples
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$ttest} \tab \tab \tab \tab \tab a table containing the t-test results \cr
#'   \code{results$assum$norm} \tab \tab \tab \tab \tab a table containing the normality tests \cr
#'   \code{results$assum$eqv} \tab \tab \tab \tab \tab a table containing the homogeneity of variances tests \cr
#'   \code{results$desc} \tab \tab \tab \tab \tab a table containing the group descriptives \cr
#'   \code{results$plots} \tab \tab \tab \tab \tab an array of groups of plots \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$ttest$asDF}
#'
#' \code{as.data.frame(results$ttest)}
#'
#' @export
ttestIS <- function(
    data,
    vars,
    group,
    students = TRUE,
    bf = FALSE,
    bfPrior = 0.707,
    welchs = FALSE,
    mann = FALSE,
    hypothesis = "different",
    norm = FALSE,
    qq = FALSE,
    eqv = FALSE,
    meanDiff = FALSE,
    ci = FALSE,
    ciWidth = 95,
    effectSize = FALSE,
    ciES = FALSE,
    ciWidthES = 95,
    desc = FALSE,
    plots = FALSE,
    miss = "perAnalysis",
    formula) {

    if ( ! requireNamespace("jmvcore", quietly=TRUE))
        stop("ttestIS requires jmvcore to be installed (restart may be required)")

    if ( ! missing(formula)) {
        if (missing(vars))
            vars <- jmvcore::marshalFormula(
                formula=formula,
                data=`if`( ! missing(data), data, NULL),
                from="lhs",
                required=TRUE)
        if (missing(group))
            group <- jmvcore::marshalFormula(
                formula=formula,
                data=`if`( ! missing(data), data, NULL),
                from="rhs",
                subset="1")
    }

    if ( ! missing(vars)) vars <- jmvcore::resolveQuo(jmvcore::enquo(vars))
    if ( ! missing(group)) group <- jmvcore::resolveQuo(jmvcore::enquo(group))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(vars), vars, NULL),
            `if`( ! missing(group), group, NULL))

    for (v in group) if (v %in% names(data)) data[[v]] <- as.factor(data[[v]])

    options <- ttestISOptions$new(
        vars = vars,
        group = group,
        students = students,
        bf = bf,
        bfPrior = bfPrior,
        welchs = welchs,
        mann = mann,
        hypothesis = hypothesis,
        norm = norm,
        qq = qq,
        eqv = eqv,
        meanDiff = meanDiff,
        ci = ci,
        ciWidth = ciWidth,
        effectSize = effectSize,
        ciES = ciES,
        ciWidthES = ciWidthES,
        desc = desc,
        plots = plots,
        miss = miss)

    analysis <- ttestISClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}

