% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa.h.R
\name{cfa}
\alias{cfa}
\title{Confirmatory Factor Analysis}
\usage{
cfa(data, factors = list(list(label = "Factor 1", vars = list())), resCov,
  miss = "fiml", constrain = "facVar", estTest = TRUE, ci = FALSE,
  ciWidth = 95, stdEst = FALSE, factCovEst = TRUE,
  factInterceptEst = FALSE, resCovEst = FALSE, resInterceptEst = FALSE,
  fitMeasures = list("cfi", "tli", "rmsea"), modelTest = TRUE,
  pathDiagram = FALSE, corRes = FALSE, hlCorRes = 0.1, mi = FALSE,
  hlMI = 3)
}
\arguments{
\item{data}{the data as a data frame}

\item{factors}{a list containing named lists that define the \code{label}
of the factor and the \code{vars} that belong to that factor}

\item{resCov}{a list of lists specifying the residual covariances that need
to be estimated}

\item{miss}{\code{'listwise'} or \code{'fiml'}, how to handle missing
values; \code{'listwise'} excludes a row from all analyses if one of its
entries is missing, \code{'fiml'} uses a full information maximum
likelihood method to estimate the model.}

\item{constrain}{\code{'facVar'} or \code{'facInd'}, how to contrain the
model; \code{'facVar'} fixes the factor variances to one, \code{'facInd'}
fixes each factor to the scale of its first indicator.}

\item{estTest}{\code{TRUE} (default) or \code{FALSE}, provide 'Z' and 'p'
values for the model estimates}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide a confidence
interval for the model estimates}

\item{ciWidth}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width that is used as \code{'ci'}}

\item{stdEst}{\code{TRUE} or \code{FALSE} (default), provide a standardized
estimate for the model estimates}

\item{factCovEst}{\code{TRUE} (default) or \code{FALSE}, provide estimates
for the factor (co)variances}

\item{factInterceptEst}{\code{TRUE} or \code{FALSE} (default), provide
estimates for the factor intercepts}

\item{resCovEst}{\code{TRUE} (default) or \code{FALSE}, provide estimates
for the residual (co)variances}

\item{resInterceptEst}{\code{TRUE} or \code{FALSE} (default), provide
estimates for the residual intercepts}

\item{fitMeasures}{one or more of \code{'cfi'}, \code{'tli'},
\code{'srmr'}, \code{'rmsea'}, \code{'aic'}, or \code{'bic'}; use CFI, TLI,
SRMR, RMSEA + 90\% confidence interval, adjusted AIC, and BIC model fit
measures, respectively}

\item{modelTest}{\code{TRUE} (default) or \code{FALSE}, provide a
chi-square test for exact fit that compares the model with the perfect
fitting model}

\item{pathDiagram}{\code{TRUE} or \code{FALSE} (default), provide a path
diagram of the model}

\item{corRes}{\code{TRUE} or \code{FALSE} (default), provide the residuals
for the observed correlation matrix (i.e., the difference between the
expected correlation matrix and the observed correlation matrix)}

\item{hlCorRes}{a number (default: 0.1), highlight values in the
\code{'corRes'} table above this value}

\item{mi}{\code{TRUE} or \code{FALSE} (default), provide modification
indices for the parameters not included in the model}

\item{hlMI}{a number (default: 3), highlight values in the
\code{'modIndices'} tables above this value}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$factorLoadings} \tab \tab \tab \tab \tab a table containing the factor loadings \cr
  \code{results$factorEst$factorCov} \tab \tab \tab \tab \tab a table containing factor covariances estimates \cr
  \code{results$factorEst$factorIntercept} \tab \tab \tab \tab \tab a table containing factor intercept estimates \cr
  \code{results$resEst$resCov} \tab \tab \tab \tab \tab a table containing residual covariances estimates \cr
  \code{results$resEst$resIntercept} \tab \tab \tab \tab \tab a table containing residual intercept estimates \cr
  \code{results$modelFit$test} \tab \tab \tab \tab \tab a table containing the chi-square test for exact fit \cr
  \code{results$modelFit$fitMeasures} \tab \tab \tab \tab \tab a table containing fit measures \cr
  \code{results$modelPerformance$corRes} \tab \tab \tab \tab \tab a table containing residuals for the observed correlation matrix \cr
  \code{results$modelPerformance$modIndices} \tab \tab \tab \tab \tab a group \cr
  \code{results$pathDiagram} \tab \tab \tab \tab \tab an image containing the model path diagram \cr
  \code{results$modelSyntax} \tab \tab \tab \tab \tab the lavaan syntax used to fit the model \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$factorLoadings$asDF}

\code{as.data.frame(results$factorLoadings)}
}
\description{
Confirmatory Factor Analysis
}
\examples{
data <- lavaan::HolzingerSwineford1939

jmv::cfa(
    data = data,
    factors = list(
        list(label="Visual", vars=c("x1", "x2", "x3")),
        list(label="Textual", vars=c("x4", "x5", "x6")),
        list(label="Speed", vars=c("x7", "x8", "x9"))),
    resCov = NULL)

# Confirmatory Factor Analysis
#
#  Factor Loadings
#  -----------------------------------------------------------------
#    Factor     Indicator    Estimate    SE        Z        p
#  -----------------------------------------------------------------
#    Visual     x1              0.900    0.0832    10.81    < .001
#               x2              0.498    0.0808     6.16    < .001
#               x3              0.656    0.0776     8.46    < .001
#    Textual    x4              0.990    0.0567    17.46    < .001
#               x5              1.102    0.0626    17.60    < .001
#               x6              0.917    0.0538    17.05    < .001
#    Speed      x7              0.619    0.0743     8.34    < .001
#               x8              0.731    0.0755     9.68    < .001
#               x9              0.670    0.0775     8.64    < .001
#  -----------------------------------------------------------------
#
#
# Factor Estimates
#
#  Factor Covariances
#  --------------------------------------------------------------
#                          Estimate    SE        Z       p
#  --------------------------------------------------------------
#    Visual     Visual      1.000 a
#               Textual     0.459      0.0635    7.22    < .001
#               Speed       0.471      0.0862    5.46    < .001
#    Textual    Textual     1.000 a
#               Speed       0.283      0.0715    3.96    < .001
#    Speed      Speed       1.000 a
#  --------------------------------------------------------------
#    a fixed parameter
#
#
# Model Fit
#
#  Test for Exact Fit
#  ------------------------
#    X²      df    p
#  ------------------------
#    85.3    24    < .001
#  ------------------------
#
#
#
#  Fit Measures
#  -----------------------------------------------
#    CFI      TLI      RMSEA     Lower     Upper
#  -----------------------------------------------
#    0.931    0.896    0.0921    0.0714    0.114
#  -----------------------------------------------
#
#

}
