% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterpermute.R
\name{clusterpermute}
\alias{clusterpermute}
\title{Conduct a cluster-based permutation test}
\usage{
clusterpermute(
  jlmer_spec,
  family = c("gaussian", "binomial"),
  statistic = c("t", "chisq"),
  threshold,
  nsim = 100L,
  predictors = NULL,
  binned = FALSE,
  top_n = Inf,
  add1 = TRUE,
  ...,
  progress = TRUE
)
}
\arguments{
\item{jlmer_spec}{Data prepped for jlmer from \code{make_jlmer_spec()}}

\item{family}{A GLM family. Currently supports "gaussian" and "binomial".}

\item{statistic}{Test statistic for calculating cluster mass.
Can be one of \code{"t"} (default) from the regression model output or
\code{"chisq"} from a likelihood ratio test (takes about twice as long to calculate).}

\item{threshold}{The threshold value that the statistic must pass to contribute to cluster mass.
Interpretation differs on the choice of statistic (more below):
\itemize{
\item If \code{statistic = "t"}, the threshold for t-value (beta/std.err) from the regression model.
\item If \code{statistic = "chisq"}, the threshold for the p-value of chi-squared statistics from likelihood ratio tests.
}}

\item{nsim}{Number of simulations description}

\item{predictors}{(Optional) a subset of predictors to test. Defaults to \code{NULL} which tests all predictors.}

\item{binned}{Whether the data has been aggregated/collapsed into time bins. Defaults to \code{FALSE},
which requires a cluster to span at least two time points. If \code{TRUE}, allows length-1 clusters to exist.}

\item{top_n}{How many clusters to return, in the order of the size of the cluster-mass statistic.
Defaults to \code{Inf} which return all detected clusters.}

\item{add1}{Whether to add 1 to the numerator and denominator when calculating the p-value.
Use \code{TRUE} to effectively count the observed statistic as part of the permuted
null distribution (recommended with larger \code{nsim} prior to publishing results).}

\item{...}{Optional arguments passed to Julia for model fitting.
Defaults to \code{fast = TRUE} (when \code{family = "binomial"}) and \code{progress = FALSE}.}

\item{progress}{Defaults to \code{TRUE}, which prints progress on each step of the cluster permutation test.}
}
\value{
A list of \code{null_cluster_dists} and \code{empirical_clusters} with p-values
}
\description{
Conduct a cluster-based permutation test
}
\examples{
\dontshow{if (JuliaConnectoR::juliaSetupOk()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
\dontshow{
options("jlmerclusterperm.nthreads" = 2)
jlmerclusterperm_setup(verbose = FALSE)
julia_progress(show = FALSE)
}

library(dplyr, warn.conflicts = FALSE)

# Specification object
spec <- make_jlmer_spec(
  weight ~ 1 + Diet, filter(ChickWeight, Time <= 20),
  subject = "Chick", time = "Time"
)
spec

# Should minimally provide `threshold` and `nsim`, in addition to the spec object
reset_rng_state()
CPA <- clusterpermute(spec, threshold = 2, nsim = 100, progress = FALSE)
CPA

# CPA is a list of `<null_cluster_dists>` and `<empirical_clusters>` objects
sapply(CPA, class)

# You can extract the individual components for further inspection
CPA$null_cluster_dists
CPA$empirical_clusters

\dontshow{
JuliaConnectoR::stopJulia()
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=compute_timewise_statistics]{compute_timewise_statistics()}}, \code{\link[=permute_timewise_statistics]{permute_timewise_statistics()}},
\code{\link[=extract_empirical_clusters]{extract_empirical_clusters()}}, \code{\link[=extract_null_cluster_dists]{extract_null_cluster_dists()}},
\code{\link[=calculate_clusters_pvalues]{calculate_clusters_pvalues()}}
}
