% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature-scaling.R
\name{feature_scaling}
\alias{feature_scaling}
\alias{feature_rescale}
\alias{feature_derescale}
\alias{feature_norm}
\alias{feature_denorm}
\alias{feature_standardize}
\alias{feature_destandardize}
\title{Feature Scaling}
\usage{
feature_rescale(x, x_min = NULL, x_max = NULL)

feature_derescale(x_rescaled, x_min, x_max)

feature_norm(x, x_norm = NULL)

feature_denorm(x_norm_std, x_norm = NULL)

feature_standardize(x, x_mean = NULL, x_sd = NULL)

feature_destandardize(x_std, x_mean = NULL, x_sd = NULL)
}
\arguments{
\item{x}{Numeric values}

\item{x_min}{Minimum non-normalized numeric value}

\item{x_max}{Maximum non-normalized numeric value}

\item{x_rescaled}{Rescaled values of \code{x}.}

\item{x_norm}{Euclidean norm of x}

\item{x_norm_std}{Euclidean vector of normalized \code{x} values.}

\item{x_mean}{Mean of \code{x} values}

\item{x_sd}{Standard Deviation of \code{x} values}

\item{x_std}{Z-transformed \code{x} values}
}
\value{
A \code{numeric} vector.
}
\description{
Scale features in a datasets.
}
\details{
The following functions provide a means to either scale features or
to descale the features and return them to normal. These functions
are ideal for working with optimizers.

\tabular{ll}{
Feature Scale       \tab Feature Descale      \cr
feature_rescale     \tab feature_derescale    \cr
feature_norm        \tab feature_denorm       \cr
feature_standardize \tab feature_destandardize
}
}
\section{Feature Rescaling}{


Convert the original data \eqn{x} to \eqn{x_{scaled}}:

\deqn{x[scaled] = (x-x[min])/(x[max]-x[min])}{x_{scaled} = \frac{(x-x_{min})}{(x_{max}-x_{min})}}

To move from the rescaled value \eqn{x_{scaled}} to the original value \eqn{x} use:

\deqn{x = x[scaled] * (x[max] - x[min]) + x[min]}{x = x_{scaled} * (x_{max} - x_{min}) + x_{min}}
}

\section{Feature Standardization}{


Convert the original data \eqn{x} to \eqn{x_{std}}:

\deqn{x[std] = (x-avg[x])/(sigma[x])}{x_{std} = \frac{(x-\bar{x})}{\sigma_{x}}}

To move from the standardized value \eqn{x_{std}} to the original value \eqn{x} use:

\deqn{x = x[std] * sigma[x] + avg[x]}{x = x_{std} \sigma_{x} + \bar{x}}
}

\section{Feature Normalization}{


Convert the original data \eqn{x} to \eqn{x_{norm}}:

\deqn{x[norm] = (x)/||x||}{x_{norm} = \frac{x}{\left\| x \right\|}}

To move from the normalized value \eqn{x_{norm}} to the original value \eqn{x} use:

\deqn{x = x[norm] * ||x||}{x = x_{norm} \left\| x \right\|}
}

\examples{

# Rescaling Features
temperatures = c(94.2, 88.1, 32, 0)

temp_min = min(temperatures)
temp_max = max(temperatures)

temperatures_norm   = feature_rescale(temp_min, temp_max)
temperatures_denorm = feature_derescale(temperatures_norm, temp_min, temp_max)

all.equal(temperatures, temperatures_denorm)
 
# Norming Features
x = 1:10

x_norm = sqrt(sum(x^2))

x_norm_std = feature_norm(x, x_norm)

x_recover = feature_denorm(x_norm_std, x_norm)
all.equal(x, x_recover)

# Standardizing Features
x      = 1:10

x_mean = mean(x)
x_sd   = sd(x)

x_std  = feature_standardize(x, x_mean, x_sd)
x_recovery = feature_destandardize(x, x_mean, x_sd)

all.equal(x, x_recovery)
}
\author{
James Balamuta
}
