% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{acc}
\alias{acc}
\title{Accuracy of the Model}
\usage{
acc(y, yhat)
}
\arguments{
\item{y}{A \code{vector} of the true \eqn{y} values}

\item{yhat}{A \code{vector} of predicted \eqn{\hat{y}}{y hat} values.}
}
\value{
The accuracy of the classification in \code{numeric} form.
}
\description{
Calculates the accuracy of the model by taking the mean of the number of times
the truth, \eqn{y}, equals the predicted, \eqn{\hat{y}}{y hat}.
}
\examples{
# Set seed for reproducibility
set.seed(100)

# Generate data
n = 1e2

y = round(runif(n))
yhat = round(runif(n))

# Compute
o = acc(y, yhat)
}
