% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pairwise.chisq.test}
\alias{pairwise.chisq.test}
\title{Pairwise Chi-Square Tests}
\usage{
pairwise.chisq.test(A, B, p.adjust.method = "bonferroni")
}
\arguments{
\item{A}{A factor with two levels. The first variable.}

\item{B}{A factor with two or more levels. The second variable.}

\item{p.adjust.method}{A string specifying the method for adjusting p-values. Default is "bonferroni".}
}
\value{
A data frame with the results of the pairwise Chi-Square tests. Includes the groups, Chi-Square statistic, degrees of freedom, p-values, adjusted p-values, and significance stars.
}
\description{
This function performs pairwise Chi-Square tests for two factors.
}
\details{
This function creates all possible pairs of levels of factor B and performs a Chi-Square test for each pair of B on variable A. The p-values are adjusted according to the specified method.
#' This function is created for educational purposes only. For exact p-values, consider using \code{reporttools::pairwise.fisher.test()}.
}
\examples{
set.seed(123)
A <- factor(sample(c("Male", "Female"), 100, replace = TRUE))
B <- factor(sample(c("Location1", "Location2", "Location3"), 100, replace = TRUE))
pairwise.chisq.test(A, B, "holm")
}
