% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report}
\alias{report}
\title{Create a statistical audit sampling report}
\usage{
report(object, file = 'report.html', format = 'html_document')
}
\arguments{
\item{object}{an object of class \code{jfaEvaluation} as returned by the \code{evaluation()} function.}

\item{file}{a character specifying the name of the report (e.g. \code{report.html}). By default, the report is created in your current working directory.}

\item{format}{a character specifying the output format of the report. Possible options are \code{html_document} (default) and \code{pdf_document}, but compiling to \code{pdf} format requires a local version of MikTex.}
}
\value{
A \code{html} or \code{pdf} file containing a report of the evaluation.
}
\description{
This function takes an object of class \code{jfaEvaluation} as returned by the \code{evaluation()} function automatically generates a \code{html} or \code{pdf} report containing the analysis results and their interpretation.

For more details on how to use this function, see the package vignette:
\code{vignette('jfa', package = 'jfa')}
}
\examples{
data('BuildIt')

# Draw a sample of 100 monetary units from the population using
# fixed interval monetary unit sampling
sample <- selection(population = BuildIt, sampleSize = 100, 
          algorithm = 'interval', units = 'mus', bookValues = 'bookValue')$sample

# Evaluate using the Stringer bound
result <- evaluation(confidence = 0.95, materiality = 0.05, 
                     method = 'stringer', sample = sample, 
                     bookValues = 'bookValue', auditValues = 'auditValue')

\dontrun{ 
 report(result) 
}

}
\seealso{
\code{\link{auditPrior}} \code{\link{planning}} \code{\link{selection}} \code{\link{evaluation}} \code{\link{auditBF}}
}
\author{
Koen Derks, \email{k.derks@nyenrode.nl}
}
\keyword{audit}
\keyword{evaluation}
\keyword{report}
