% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_themes.R
\name{theme_dark_bg}
\alias{theme_dark_bg}
\alias{theme_light_bg}
\title{minimal theme for dark backgrounds}
\usage{
theme_dark_bg(base_size = 12, base_family = "sans",
  base_line_size = base_size/22, base_rect_size = base_size/22)

theme_light_bg(base_size = 12, base_family = "sans",
  base_line_size = base_size/22, base_rect_size = base_size/22)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{base_line_size}{base size for line elements}

\item{base_rect_size}{base size for rect elements}
}
\description{
minimal theme for dark backgrounds

minimal theme for light backgrounds
}
\examples{
library(ggplot2)

p <- ggplot(mtcars) + geom_point(aes(x = wt, y = mpg,
         colour = factor(gear))) + facet_grid(vs~am)
p + theme_dark_bg()


p <- ggplot(mtcars) + geom_point(aes(x = wt, y = mpg,
         colour = factor(gear))) + facet_grid(vs~am)
p + theme_light_bg()

}
