% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caterplot_compare.R
\name{caterplot_compare}
\alias{caterplot_compare}
\title{Compare Posterior Estimates from Bayesian Models}
\usage{
caterplot_compare(
  model1,
  model2 = NULL,
  pars,
  plotmath.labels = NULL,
  model1.name = "Model 1",
  model2.name = "Model 2",
  model.legend.title = "Model",
  ref.lines = c(0),
  colors = c("blue", "red"),
  point.size = 3,
  point.shapes = c(16, 17),
  prob = 0.5,
  prob.outer = 0.9,
  point.est = "median",
  x.lab = "Estimate",
  y.lab = NULL,
  inner.line.thickness = 2,
  outer.line.thickness = 0.8,
  ...
)
}
\arguments{
\item{model1}{An object containing MCMC draws. Various formats (e.g., arrays, matrices, data frames, `posterior::draws` objects) are accepted.}

\item{model2}{Optional object containing MCMC draws. Accepted formats are the same as for `model1`.}

\item{pars}{Character vector of parameter names to include in the plot.}

\item{plotmath.labels}{Optional character vector for y-axis labels. If provided in R's plotmath syntax (e.g., for Greek letters or mathematical symbols), these labels will be displayed on the plot.}

\item{model1.name}{Text for the label of the first model.}

\item{model2.name}{Text for the label of the second model.}

\item{model.legend.title}{Text for the title of the model legend.}

\item{ref.lines}{Numeric value indicating vertical reference lines.}

\item{colors}{Character vector specifying the colors for models.}

\item{point.size}{Numeric value for the size of points in the plot.}

\item{point.shapes}{Numeric or character vector specifying the shapes for points, one for each model.}

\item{prob}{Numeric value for the probability mass to include in the inner interval.}

\item{prob.outer}{Numeric value for the probability mass to include in the outer interval.}

\item{point.est}{Text specifying the type of point estimate to show. Either `"median"` (the default), `"mean"`, or `"none"`.}

\item{x.lab}{Text with the label of the x-axis.}

\item{y.lab}{Text with the label of the y-axis.}

\item{inner.line.thickness}{Numeric value for the thickness of the inner interval line.}

\item{outer.line.thickness}{Numeric value for the thickness of the outer interval line.}

\item{...}{\dots}
}
\description{
Generates a caterpillar-style plot (forest plot) for visualizing and comparing
posterior parameter estimates from one or two Bayesian models.
This function is designed for use within the `jarbes` package and
supports models fitted via MCMC. It allows custom labels, credible intervals,
and styling for visual model comparison, particularly in meta-analytic and
hierarchical modeling contexts.
}
