% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagshelper1.R
\name{jags_plist}
\alias{jags_plist}
\title{Plist}
\usage{
jags_plist(x, p = NULL)
}
\arguments{
\item{x}{\code{jagsUI} output object}

\item{p}{String to subset parameter names, if a subset is desired}
}
\value{
A \code{list} with an element associated with each parameter.  Each element
will be a matrix with a column associated with each MCMC chain and a row for
each MCMC iteration.
}
\description{
Extracts a list of matrices, one for each saved parameter node.  Each
list element will be all posterior samples from that parameter node, arranged in
a matrix with a column associated with each MCMC chain and a row for
each MCMC iteration.
}
\note{
It is unlikely that a user will need this function; it is included
primarily as a helper function used by other functions in this package.
}
\examples{
out_plist <- jags_plist(asdf_jags_out)
str(out_plist)

a_plist <- jags_plist(asdf_jags_out, p=c("a","sig_a"))
str(a_plist)
}
\author{
Matt Tyers
}
