% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife.cor.R
\name{jackknife.cor}
\alias{jackknife.cor}
\title{Delete-d Jackknife Estimate for Correlation between Two Variables}
\usage{
jackknife.cor(x, y, d)
}
\arguments{
\item{x, y}{Numeric vectors of equal length}

\item{d}{Number of observations to be deleted from data to make jackknife samples}
}
\value{
A list containing a summary data frame of jackknife correlation
coefficient estimates with bias, standard error. t-statistics,
and confidence intervals,correlation estimate of original data and
a data frame with correlation estimates of individual jackknife samples.
}
\description{
This function creates jackknife samples from the data by
sequentially removing \emph{d} observations from the data,
calculates correlation between the two variables using the jackknife samples
and estimates the jackknife correlation coefficients, bias standard error,
standard error and confidence intervals.
}
\examples{
j.cor <- jackknife.cor(cars$speed, cars$dist, d = 2)
j.cor$jackknife.summary
j.cor$biased_cor

}
\references{
Quenouille, M. H. (1956). Notes on Bias in Estimation.
\emph{Biometrika}, \emph{43}(3/4), 353-360.
\doi{10.2307/2332914}

Tukey, J. W. (1958). Bias and Confidence in Not-quite Large Samples.
\emph{Annals of Mathematical Statistics}, \emph{29}(2), 614-623.
\doi{10.1214/aoms/1177706647}

Shi, X. (1988). A note on the delete-d jackknife variance estimators.
\emph{Statistics & Probability Letters}, \emph{6}(5), 341-347.
\doi{10.1016/0167-7152(88)90011-9}
}
\seealso{
\code{\link[=cor]{cor()}} which is used to estimate correlation coefficient.
}
