% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSF.R
\name{MSF}
\alias{MSF}
\title{Evaluation of monomial symmetric functions}
\usage{
MSF(x, lambda)
}
\arguments{
\item{x}{a numeric vector or a \code{\link[gmp]{bigq}} vector}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}
}
\value{
A number if \code{x} is numeric, a \code{bigq} rational number
if \code{x} is a \code{bigq} vector.
}
\description{
Evaluates a monomial symmetric function.
}
\examples{
x <- c(1, 2, 5/2)
lambda <- c(3, 1)
MSF(x, lambda)
library(gmp)
x <- c(as.bigq(1), as.bigq(2), as.bigq(5,2))
MSF(x, lambda)
}
