% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivo_tables.R
\name{ivo_flextable_to_xlsx}
\alias{ivo_flextable_to_xlsx}
\title{Export flextable to Excel}
\usage{
ivo_flextable_to_xlsx(
  tables,
  filename = "flextable_ex",
  format = TRUE,
  colwidths = "guess",
  caption_size = 14,
  merge_cells = TRUE,
  gridlines = FALSE
)
}
\arguments{
\item{tables}{A \code{flextable} object or a list of several \code{flextable} objects.}

\item{filename}{The name of the output file.}

\item{format}{Whether or not to use the flextable format options such as borders, colors etc. \code{TRUE} = uses the format options, \code{FALSE} = no formatting.}

\item{colwidths}{Method to determine widths for columns given their special nature in Excel.}

\item{caption_size}{The font size of the caption in the Excel output.}

\item{merge_cells}{Merge cells of repeated category values. This is in line with the regular output of ivo_table.}

\item{gridlines}{Show or hide gridlines in the Excel output.}
}
\value{
An Excel file with each flextable on an own tab.
}
\description{
Saves one or more flextables to a .xlsx file.
}
\details{
The function saves an Excel file in the current working directory with the provided flextables on separate sheets. When saving several flextables, add a name to the list elements to name the sheets in the output file. If the list elements
are not named, default names will be used.
}
\author{
Stefan Furne
library(dplyr)
library(flextable)Example flextables

tbl1 <- starwars |>
group_by(homeworld) |>
summarise(n = n()) |>
filter(n > 1 & !is.na(homeworld)) |>
flextable()

tbl2 <- starwars |>
group_by(species) |>
summarise(mean_height = mean(height)) |>
flextable()Only one flextable

ivo_flextable_to_xlsx(tbl1, "Flextable_test1.xlsx", format = FALSE, colwidths = "auto")Two tables, no named sheets

ivo_flextable_to_xlsx(list(tbl1, tbl2), "Flextable_test2.xlsx")Two tables, with named sheets

ivo_flextable_to_xlsx(
list("Planets" = tbl1, "Mean height" = tbl2),
"Flextable_test3.xlsx",
colwidths = "auto"
)
}
