% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wweights.R
\name{restring}
\alias{restring}
\title{Auxiliary function that converts an expression of variable names
into a vector of strings.}
\usage{
restring(vector, substitute = TRUE, command = "c")
}
\arguments{
\item{vector}{An expression of a list of variable names.}

\item{substitute}{Boolean option of whether or not we wish to use
the \code{substitute} command when implementing this
function. Note that this substitutes the argument of the
function. If \code{substitute = FALSE}, then the function will
instead treat the arguments as variables, and substitute in
their values.}

\item{command}{character, the name of the function defining the
vector or list, e.g. "c", "list", "l". This let's the function
determine how many characters in front to remove.}
}
\value{
A vector of variable names (strings).
}
\description{
Auxiliary function that converts an expression of variable names
into a vector of strings.
}
\examples{
a <- 4
b <- 5
ivmte:::restring(c(a, b), substitute = TRUE)
ivmte:::restring(c(a, b), substitute = FALSE)
}
