% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{audit}
\alias{audit}
\title{Audit procedure}
\usage{
audit(data, uname, m0, m1, splinesobj, vars_mtr, terms_mtr0, terms_mtr1,
  grid.nu = 20, grid.nx = 50, audit.nx = 5, audit.nu = 3,
  audit.max = 5, audit.tol = 1e-08, m1.ub, m0.ub, m1.lb, m0.lb,
  m1.ub.default = FALSE, m0.ub.default = FALSE,
  m1.lb.default = FALSE, m0.lb.default = FALSE, mte.ub, mte.lb,
  m0.dec = FALSE, m0.inc = FALSE, m1.dec = FALSE, m1.inc = FALSE,
  mte.dec = FALSE, mte.inc = FALSE, sset, gstar0, gstar1,
  obseq.tol = 0.05, lpsolver)
}
\arguments{
\item{data}{\code{data.frame} used to estimate the treatment
effects.}

\item{uname}{name declared by user to represent the unobservable
term in the MTRs.}

\item{m0}{one-sided formula for marginal treatment response
function for control group. The unobservable term can be
entered in using splines.}

\item{m1}{one-sided formula for marginal treatment response
function for treated group.}

\item{splinesobj}{list of spline components in the MTRs for treated
and control groups. Spline terms are extracted using
\code{\link{removeSplines}}.}

\item{vars_mtr}{all variables entering into the MTRs for treated
and control groups.}

\item{terms_mtr0}{all terms entering into the MTRs for control
group.}

\item{terms_mtr1}{all terms entering into the MTRs for treated
group.}

\item{grid.nu}{number of evenly spread points in the interval [0,
1] of the unobservable u used to form the grid for imposing
shape restrictions on the MTRs.}

\item{grid.nx}{number of evenly spread points of the covariates to
use to form the grid for imposing shape restrictions on the
MTRs.}

\item{audit.nx}{number of points on the covariates space to audit
in each iteration of the audit procedure.}

\item{audit.nu}{number of points in the interval [0, 1],
corresponding to the normalized value of the unobservable term,
to audit in each iteration of the audit procedure.}

\item{audit.max}{maximum number of iterations in the audit
procedure.}

\item{audit.tol}{tolerance for determining when to end the audit
procedure. Namely, if the percentage change in the upper and
lower bounds both fall below \code{audit.tol} between
iterations of the audit, the audit procedure ends.}

\item{m1.ub}{numeric value for upper bound on MTR for treated
group.}

\item{m0.ub}{numeric value for upper bound on MTR for control
group.}

\item{m1.lb}{numeric value for lower bound on MTR for treated
group.}

\item{m0.lb}{numeric value for lower bound on MTR for control
group.}

\item{m1.ub.default}{boolean, default set to TRUE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{m0.ub.default}{boolean, default set to TRUE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{m1.lb.default}{boolean, default set to TRUE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{m0.lb.default}{boolean, default set to TRUE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{mte.ub}{numeric value for upper bound on treatment effect
paramter of interest.}

\item{mte.lb}{numeric value for lower bound on treatment effect
paramter of interest.}

\item{m0.dec}{logical, equal to TRUE if we want MTR for control
group to be weakly monotone decreasing.}

\item{m0.inc}{logical, equal to TRUE if we want MTR for control
group to be weakly monotone increasing.}

\item{m1.dec}{logical, equal to TRUE if we want MTR for treated
group to be weakly monotone decreasing.}

\item{m1.inc}{logical, equal to TRUE if we want MTR for treated
group to be weakly monotone increasing.}

\item{mte.dec}{logical, equal to TRUE if we want the MTE to be
weakly monotone decreasing.}

\item{mte.inc}{logical, equal to TRUE if we want the MTE to be
weakly monotone decreasing.}

\item{sset}{a list containing the point estimates and gamma
components associated with each element in the S-set.}

\item{gstar0}{set of expectations for each terms of the MTR for the
control group.}

\item{gstar1}{set of expectations for each terms of the MTR for the
control group.}

\item{obseq.tol}{tolerance level for how much more the solution is
permitted to violate observational equivalence of the IV-like
estimands. The threshold multiplies the violation of the
observational equivalence, i.e. a threshold of 0 corresponds to
the assumption that the model is correctly specified, and that
any violation of observational equivalence is due to
statistical noise.}

\item{lpsolver}{name of the linear programming package in R used to
obtain the bounds on the treatment effect.}
}
\value{
a list. Included in the list is the minimum violation of
    observational equivalence of the set of IV-like estimands, as
    well as the list of matrices and vectors associated with
    solving the LP problem.
}
\description{
This is the wrapper for running the entire audit procedure. This
function sets up the LP problem of minimizing the violation of
observational equivalence for the set of IV-like estimands, while
satisfying boundedness and monotonicity constraints declared by the
user. Rather than enforce boundedness and monotonicity hold across
the entire support of covariates and unobservables, this procedure
enforces the conditions over a subset of points in a grid. This
grid corresponds to the set of values the covariates can take, and a
subset of values of the unobservable term. The size of this grid is
specified by the user in the function arguments. The procedure then
goes on to check whether the constraints are satisfied at points
off the grid. Any point where either the boundedness or
monotonicity constraints are violated are incorporated into the
grid, and the process is repeated until the grid incorporates the
entire support of the covariates, or until some a maximum number of
iterations is reached.
}
\examples{

set.seed(10L)

## Declare empty list to be updated (in the event multiple IV like
## specifications are provided
sSet <- list()

## Declare MTR formulas
formula1 = ~ 1 + u
formula0 = ~ 1 + u

## Construct object that separates out non-spline components of MTR
## formulas from the spline components. The MTR functions are
## obtained from this object by the function 'genSSet'
splinesList = list(removeSplines(formula0), removeSplines(formula1))

## Construct MTR polynomials
polynomials0 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

polynomials1 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

## Generate propensity score model
propensityObj <- propensity(formula = d ~ z,
                            data = dtm,
                            link = "linear")

## Generate IV estimates
ivEstimates <- ivEstimate(formula = ey ~ d | z,
                          data = dtm,
                          components = l(intercept, d),
                          treat = d,
                          list = FALSE)

## Generate target gamma moments
targetGamma <- genTarget(treat = "d",
                         m0 = ~ 1 + u,
                         m1 = ~ 1 + u,
                         uname = u,
                         target = "atu",
                         data = dtm,
                         splinesobj = splinesList,
                         pmodobj = propensityObj,
                         pm0 = polynomials0,
                         pm1 = polynomials1,
                         point = FALSE)

## Construct S-set, which contains the coefficients and weights
## corresponding to various IV-like estimands
sSet <- genSSet(data = dtm,
                sset = sSet,
                sest = ivEstimates,
                splinesobj = splinesList,
                pmodobj = propensityObj$phat,
                pm0 = polynomials0,
                pm1 = polynomials1,
                ncomponents = 2,
                scount = 1,
                yvar = "ey",
                dvar = "d",
                means = TRUE)

## Perform audit procedure and return bounds
audit(data = dtm,
      uname = u,
      m0 = formula0,
      m1 = formula1,
      splinesobj = splinesList,
      vars_mtr = "u",
      terms_mtr0 = "u",
      terms_mtr1 = "u",
      sset = sSet$sset,
      gstar0 = targetGamma$gstar0,
      gstar1 = targetGamma$gstar1,
      m0.inc = TRUE,
      m1.dec = TRUE,
      m0.lb = 0.2,
      m1.ub = 0.8,
      audit.max = 5,
      lpsolver = "lpSolveAPI")

}
