% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{res_df}
\alias{res_df}
\title{Retrieve the residual degrees of freedom from the model.}
\usage{
res_df(model)
}
\arguments{
\item{model}{A fitted regression model (using gam, or bam).}
}
\value{
Numeric value: residual degrees of freedom from the model.
}
\description{
Retrieve the residual degrees of freedom from the model.
}
\examples{
data(simdat)

# Fit simple GAM model:
gam1 <- bam(Y ~ s(Time), data=simdat, discrete=TRUE)
res_df(gam1)
# ... which is the same as:

modeledf(gam1)

}
\seealso{
Other Utility functions: 
\code{\link{convertNonAlphanumeric}()},
\code{\link{corfit}()},
\code{\link{diff_terms}()},
\code{\link{find_difference}()},
\code{\link{missing_est}()},
\code{\link{modeledf}()},
\code{\link{observations}()},
\code{\link{print_summary}()},
\code{\link{refLevels}()},
\code{\link{summary_data}()},
\code{\link{timeBins}()}
}
\concept{Utility functions}
