% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{gamtabs}
\alias{gamtabs}
\title{Convert model summary into Latex/HTML table for knitr/R Markdown reports.}
\usage{
gamtabs(model, caption = " ", label = "tab.gam", pnames = NA,
  snames = NA, ptab = NA, stab = NA, ...)
}
\arguments{
\item{model}{A GAM(M) model build in the package \code{\link[mgcv]{mgcv}} 
using \code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.
Alternatively, a summary of a GAMM model could be provided.}

\item{caption}{A string with the caption for the table.}

\item{label}{A string for the label to refer to the table in the markdown 
document.}

\item{pnames}{A vector with labels to relabel the rows in the parametric 
part of the summary.}

\item{snames}{A vector with labels to relabel the rows in the smooth
part of the summary.}

\item{ptab}{A vector with labels to relabel the column names of the 
parametric summary.}

\item{stab}{A vector with labels to relabel the column names of the 
smooth summary.}

\item{...}{Optional additional arguments which are passed to 
\code{xtable} (see 'help(xtable)').}
}
\value{
A vector with color values.
}
\description{
Convert model summary into Latex/HTML table for knitr/R Markdown reports.
}
\section{Note}{
 
This function is useful for markdown documents using the package 
\code{knitr} to integrate R code with Latex and Sweave. This 
function requires the package \code{xtable}.
}

\examples{
data(simdat)
\dontrun{
# Model with random effect and interactions:
m1 <- bam(Y ~ Group+te(Time, Trial, by=Group),
    data=simdat)
summary(m1)
gamtabs(m1, caption='Summary of m1')
}
# See for more examples:
vignette("inspect", package="itsadug")
}
\seealso{
\code{\link[mgcv]{summary.gam}}, \code{\link[mgcv]{gam}}, 
\code{\link[mgcv]{bam}}.

Other Functions for model inspection: \code{\link{fvisgam}},
  \code{\link{inspect_random}}, \code{\link{plot_data}},
  \code{\link{plot_parametric}}, \code{\link{plot_smooth}},
  \code{\link{plot_topo}}, \code{\link{pvisgam}}
}
\author{
R. Harald Baayen
}
