% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/data_utility_functions.R
\name{group_sort}
\alias{group_sort}
\title{Utility function.}
\usage{
group_sort(x, group = NULL, decreasing = FALSE)
}
\arguments{
\item{x}{A vector to be sorted.}

\item{group}{A names list that specify the different groups to split the
data.}

\item{decreasing}{Logical: whether or not the sort order should be
decreasing.}
}
\value{
Indices indicating the order of vector x per group.
}
\description{
Function uses \code{\link[base]{sort.list}} to return indices
of of a vector, sorted per group.
}
\examples{
data(simdat)
range(simdat$Y)
ind <- group_sort(simdat$Y,
    group=list(Group=simdat$Group, Trial=simdat$Trial))
head(simdat[ind,])
}
\author{
Jacolien van Rij
}
\seealso{
\code{\link[base]{sort.list}}

Other Data utility functions: \code{\link{findAbsMin}};
  \code{\link{find_n_neighbors}};
  \code{\link{move_n_point}}; \code{\link{print_summary}};
  \code{\link{summary_data}}
}

