% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itrax_restspectra.r
\name{itrax_restspectra}
\alias{itrax_restspectra}
\title{Make a spectrograph from raw Itrax data spectra files}
\usage{
itrax_restspectra(
  foldername = "XRF data",
  parameters = "settings.dfl",
  datapos = 37,
  plot = TRUE,
  trans = "pseudo_log"
)
}
\arguments{
\item{foldername}{defines the folder where the spectra \code{"*.spe"} files are located}

\item{parameters}{optionally, defines the Q-Spec settings file from which to calculate the channel energies}

\item{datapos}{defines the row at which spectral data begins in the files}

\item{plot}{TRUE/FALSE, selects whether to create a plot as a side-effect}

\item{trans}{transformation applied in the plot - see `?ggplot2::scales_colour_gradient()` for options}
}
\value{
a dataframe of all the spectral data
}
\description{
Parses a folder full of raw spectra files from an Itrax core scanner and produces a spectral graph of all the data by position
}
\examples{
\dontrun{itrax_restspectra("~/itraxBook/CD166_19_(2020)/CD166_19_S1/CD166_19_S1/XRF data")}

}
