% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user.R
\name{use.theme}
\alias{use.theme}
\title{Extract theme from inbuilt_themes}
\usage{
use.theme(type, style = "default")
}
\arguments{
\item{type}{a character specifying the template type used for extracting.
Following choices are possible: "COLLAPSE","PRUNE","SPACING","TREE_COLORS",
"DATASET_STYLE","LABELS","DATASET_TEXT","DATASET_COLORSTRIP",
"DATASET_BINARY","DATASET_GRADIENT","DATASET_HEATMAP","DATASET_SYMBOL",
"DATASET_EXTERNALSHAPE","DATASET_DOMAINS","DATASET_SIMPLEBAR",
"DATASET_MULTIBAR","DATASET_BOXPLOT","DATASET_LINECHART","DATASET_PIECHART",
"DATASET_ALIGNMENT","DATASET_CONNECTION","DATASET_IMAGE","POPUP_INFO.}

\item{style}{a character specifying the specific version of template type
used for extracting. The default value is "default" style for all types.}
}
\value{
a itol.theme object containing

\item{type}{This group holds information about the template type of
the data only. This is a very critical piece of information. In many
functions of the itol.toolkit package, the template type information is
used to determine the different data processing and input/output methods.}

\item{sep}{This group holds data separator information only.
This is one of the most important parameters for data reading and output.
It is a separate category because it is frequently used and is an input
parameter for other subsequent parameters to be read.}

\item{profile}{This group contains basic information about the
dataset, such as the dataset name and a color label to distinguish the
dataset. The dataset name is extremely important. This parameter is used
almost throughout the data processing of the itol.toolkit package.
With the content of this parameter as the key value, the data and theme
information of the dataset are associated. In turn, high throughput
learning and writing of large-scale data can be achieved. This parameter
is not included in some template types with a particularly simple structure,
so we choose a file name or a user-defined method as the key value.}

\item{field}{This group contains information about each sample
within the dataset, and this type of parameter exists only for multi-sample
data. This information even includes the clustering tree between samples.
This information is usually stored as part of the column names in the
metadata part or abundance information of the itol.hub object.}

\item{common_themes}{These themes are used at high frequency in
different templates. These parameters are small in number but constitute some
common features of iTOL visual style settings, such as legend, margin, etc.}

\item{specific_themes}{These themes are used only in specific
templates. The number of these parameters is very large. However, most of
them are used in only one template to control the style details of the
visualization. By unifying these parameters and calling them according to the
template type, users can perform secondary development and data processing
with a high degree of parameter aggregation without worrying too much about
the differences between different template types.}
}
\description{
Extract theme from 23 template types in inbuilt_themes data
in package.
}
\examples{
theme <- use.theme("COLLAPSE")
}
