% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_model-building.R
\name{set_obs}
\alias{set_obs}
\title{Set observations in a network model}
\usage{
set_obs(nm, data, comp, size, prop, time, group_by)
}
\arguments{
\item{nm}{A \code{networkModel} object (e.g. output from
\code{\link{new_networkModel}})}

\item{data}{A tibble containing the observations. If NULL, remove
observations from the model.}

\item{comp}{String, name of the \code{data} column with the compartment
names}

\item{size}{String, name of the \code{data} column with the compartment
sizes}

\item{prop}{String, name of the \code{data} column with the compartment
proportions of heavy tracer}

\item{time}{String, name of the \code{data} column with the sampling times}

\item{group_by}{Optional vector of string giving the names of the columns to
use for grouping the data into replicates}
}
\value{
A \code{networkModel} object.
}
\description{
Set observations in a network model
}
\examples{
# Using the topology from the Trinidad case study
m <- new_networkModel() \%>\%
  set_topo("NH4, NO3 -> epi, FBOM", "epi -> petro, pseph",
           "FBOM -> tricor", "petro, tricor -> arg")

# Taking initial condtions from the 'lalaja' dataset at t=0
inits <- lalaja[lalaja[["time.days"]] == 0, ]
inits
m <- set_init(m, inits, comp = "compartment", size = "mgN.per.m2",
              prop = "prop15N", group_by = "transect")
m

# Taking observations from 'lalaja'
m <- set_obs(m, lalaja[lalaja[["time.days"]] > 0, ], time = "time.days")
m
plot(m)

}
