% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoread.R
\name{iso_reread_files}
\alias{iso_reread_files}
\alias{iso_reread_all_files}
\alias{iso_reread_changed_files}
\alias{iso_reread_outdated_files}
\alias{iso_reread_problem_files}
\alias{iso_reread_storage}
\alias{iso_reread_archive}
\title{Re-read iso_files}
\usage{
iso_reread_files(iso_files, ...)

iso_reread_all_files(
  iso_files,
  ...,
  stop_if_missing = FALSE,
  quiet = default(quiet)
)

iso_reread_changed_files(
  iso_files,
  ...,
  stop_if_missing = FALSE,
  quiet = default(quiet)
)

iso_reread_outdated_files(
  iso_files,
  ...,
  stop_if_missing = FALSE,
  quiet = default(quiet)
)

iso_reread_problem_files(
  iso_files,
  ...,
  stop_if_missing = FALSE,
  reread_files_with_errors = TRUE,
  reread_files_with_warnings = FALSE,
  quiet = default(quiet)
)

iso_reread_storage(...)

iso_reread_archive(...)
}
\arguments{
\item{iso_files}{collection of iso_files}

\item{...}{additional read parameters that should be used for re-reading the iso_files, see \code{\link{iso_read_dual_inlet}}, \code{\link{iso_read_continuous_flow}} and \code{\link{iso_read_scan}} for details (except \code{read_cache} which is always set to \code{FALSE} to force re-reads).}

\item{stop_if_missing}{whether to stop re-reading if any of the original data files are missing (if FALSE, will warn about the missing files adding a warning to them, but also re-read those that do exist)}

\item{quiet}{whether to display (quiet=FALSE) or silence (quiet = TRUE) information messages. Set parameter to overwrite global defaults for this function or set global defaults with calls to \link[=iso_info_messages]{iso_turn_info_messages_on} and \link[=iso_info_messages]{iso_turn_info_messages_off}}

\item{reread_files_with_errors}{whether to re-read files that had read in with errors the last time (default TRUE)}

\item{reread_files_with_warnings}{whether to re-read files that had read in with warnings the last time (default TRUE)}
}
\description{
Sometimes it is useful to reload isotope files from their original data files (e.g. after modifying raw data files in vendor software, or after upgrading to a newer version of the isoreader package that provides new functionality). The functions described below are intended to make this very easy. However, re-reading files from disc is only possible if file paths still point to the original raw data files. If they have moved, please use \code{\link{iso_set_file_root}} first to change the root directory of your \code{iso_files}.
}
\details{
To re-read files that have been modified on disc, please use \code{iso_reread_changed_files()}. To re-read files because of an isoreader version upgrade, please use \code{iso_reread_outdated_files()}. To try re-reading files that previously had warnings and/or errors, please use \code{iso_reread_problem_files()}.

\code{iso_reread_all_files} re-reads all files in the collection.

\code{iso_reread_changed_files} re-reads all files that have been modified (e.g. in the vendor software) since they were last read by isoreader.

\code{iso_reread_outdated_files} re-reads all files that were read with an outdated version of isoreader.

\code{iso_reread_problem_files} re-reads all files that have had errors the last time they were read by isoreader (set \code{reread_files_with_warnings = TRUE} to also re-read those that have warnings).

\code{iso_reread_storage} is deprecated.

\code{iso_reread_archive} is deprecated.
}
\examples{
# example for re-reading a saved isofile collection
iso_turn_reader_caching_off()
saved_files_path <- "saved_isofile.scan.rds"

# create saved collection
iso_get_reader_examples_folder() \%>\% 
 iso_read_scan() \%>\%
 iso_save(saved_files_path)
 
# load collection
iso_read_scan(saved_files_path) \%>\%
 # reread outdated files (alternatively "_all_" or "_changed_")
 iso_reread_outdated_files() \%>\%
 # re-save collection to its original location
 iso_save(saved_files_path)

# cleanup
unlink(saved_files_path)
}
