% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_info_operations.R
\name{iso_filter_files}
\alias{iso_filter_files}
\title{Filter iso_files}
\usage{
iso_filter_files(iso_files, ..., quiet = default(quiet))
}
\arguments{
\item{iso_files}{collection of iso_file objects}

\item{...}{dplyr-style \link[dplyr]{filter} conditions applied based on each file's file_info (see \code{\link{iso_get_file_info}})}

\item{quiet}{whether to display (quiet=FALSE) or silence (quiet = TRUE) information messages. Set parameter to overwrite global defaults for this function or set global defaults with calls to \link[=iso_info_messages]{iso_turn_info_message_on} and \link[=iso_info_messages]{iso_turn_info_message_off}}
}
\description{
Filter for specific isofiles using file info columns (\code{\link{iso_get_file_info}}). Works just like dplyr's \link[dplyr]{filter} except that it provides the user with some information on what has been filtered. Returns \code{NULL} if none of the isofiles' file info matches the filter criteria. You can also use \link[dplyr]{filter} directly to filter collections of \code{iso_file} objects.
}
\seealso{
Other file_info operations: 
\code{\link{iso_add_file_info.iso_file_list}()},
\code{\link{iso_mutate_file_info}()},
\code{\link{iso_parse_file_info}()},
\code{\link{iso_rename_file_info}()},
\code{\link{iso_select_file_info}()},
\code{\link{iso_set_file_root}()}
}
\concept{file_info operations}
