% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso-to-sfg.R
\name{iso_to_sfg}
\alias{iso_to_sfg}
\title{Convert isolines or isobands to sfg object}
\usage{
iso_to_sfg(x)
}
\arguments{
\item{x}{The object to convert.}
}
\description{
Convert isolines or isobands to an sf geometry collection (\code{sfg}) object. Further downstream
processing needs to happen via the sf package.
}
\examples{
library(sf)
library(ggplot2)

m <- matrix(c(0, 2, 2, 2, 0,
              0, 1, 0, 1, 0,
              0, 1, 0, 0, 0,
              0, 1, 0, 1, 0,
              0, 0, 0, 0, 0), 5, 5, byrow = TRUE)

z <- isolines(1:ncol(m), nrow(m):1, m, c(0.5, 1.5))
lines <- iso_to_sfg(z)
x <- st_sf(level = names(lines), geometry = st_sfc(lines))
ggplot(x) + geom_sf(aes(color = level))

m <- volcano
b <- isobands((1:ncol(m))/(ncol(m)+1), (nrow(m):1)/(nrow(m)+1), m,
              10*9:19, 10*10:20)
bands <- iso_to_sfg(b)
x <- st_sf(level = as.numeric(sub(":.*", "", names(bands))), geometry = st_sfc(bands))
ggplot(x) + geom_sf(aes(color = level, fill = level))
}
