% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isnimgm.R
\name{definemissingstatus}
\alias{definemissingstatus}
\title{Utility function to generate missing status variables in longitudinal data with dropout and/or intermittent missingness.}
\usage{
definemissingstatus(data, id, time, y)
}
\arguments{
\item{data}{the name of the panel dataset in the long format with each row denoting a subject-visit observation
for ALL the planned visits, regardless of being missed or not. When a subject is lost to follow up, the data set
 must include the observation at the first time of being lost to follow up.}

\item{id}{the name of the level-2 clustering variable.}

\item{time}{the name of the variable denoting the time of the visit. Can set time=NULL if data is already sorted by id and time within 
id.}

\item{y}{the name of the outcome variable of the interest that is subject to missingness.}
}
\value{
a dataset with the following three new variables added: 
\itemize{
   \item    g_ : missingness indicator, "O"-observed, "I"-intermittent missing, "D"-dropout
   \item    gp_: missingness indicator in the previous visit, "O"-observed, "I"-intermittent missing, "D"-dropout, "U"-undefined. 
   \item    yp_: the immediately observed prior outcome.
 }
}
\description{
Utility function to generate missing status variables in longitudinal data with dropout and/or intermittent missingness.
}
\examples{
qolefnew <- definemissingstatus(qolef, id=id, time=time, y=y)
}
