% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.est_irt}
\alias{summary.est_mg}
\alias{summary.est_item}
\title{Summary of item calibration}
\usage{
summary(object, ...)

\method{summary}{est_irt}(object, ...)

\method{summary}{est_mg}(object, ...)

\method{summary}{est_item}(object, ...)
}
\arguments{
\item{object}{An object of class \code{\link{est_irt}} or \code{\link{est_item}}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The method function returns a list of internal objects extracted from
\code{\link{est_irt}} or \code{\link{est_item}} object and displays a summary of
the IRT calibration results on the console panel.
}
\description{
This method function summarizes the IRT calibration results of \code{\link{est_irt}}
or \code{\link{est_item}} object.
}
\section{Methods (by class)}{
\itemize{
\item \code{summary(est_irt)}: An object created by the function \code{\link{est_irt}}.

\item \code{summary(est_mg)}: An object created by the function \code{\link{est_mg}}.

\item \code{summary(est_item)}: An object created by the function \code{\link{est_item}}.

}}
\examples{
\donttest{
# fit the 1PL model to LSAT6 data and constrain the slope parameters to be equal
fit.1pl <- est_irt(data = LSAT6, D = 1, model = "1PLM", cats = 2, fix.a.1pl = FALSE)

# summary of the estimation
summary(fit.1pl)
}

}
\seealso{
\code{\link{est_irt}}, \code{\link{est_item}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
