% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response-class-methods.R
\name{$,Response-method}
\alias{$,Response-method}
\title{Get slots of the an \code{\link{Response-class}} object.}
\usage{
\S4method{$}{Response}(x, name)
}
\arguments{
\item{x}{An \code{\link{Response-class}} object.}

\item{name}{Name of the parameter.
Available values:
\describe{
  \item{\strong{\code{'examinee_id'}}}{Extract Examinee/Subject/Student
    ID.}
  \item{\strong{\code{'item_id'}}}{Extract item ids}
  \item{\strong{\code{'testlet_id'}}}{Extract testlet IDs, if there is
    any.}
  \item{\strong{\code{'score'}}}{Extract item scores.}
  \item{\strong{\code{'raw_response'}}}{Extract raw responses.}
  \item{\strong{\code{'order'}}}{Extract item order.}
  \item{\strong{\code{'response_time'}}}{Extract response times.}
  \item{\strong{\code{'misc'}}}{Extract 'misc' field.}
}}
}
\value{
See the 'name' argument above for possible return values.
}
\description{
Get slots of the an \code{\link{Response-class}} object.
}
\examples{
resp <- response(score = c(0, 1, 0), examinee_id = "Ex-412",
                 item_id = c("I1", "I2", "I3"),
                 raw_response = c("B", "D", "A"),
                 order = 1:3,
                 response_time = c(66, 23, 89),
                 misc = list(form = "A1",
                             operational = c(TRUE, TRUE, FALSE))
                 )
resp$score
resp$item_id
resp$examinee_id
resp$raw_response
resp$order
resp$response_time
resp$misc
resp$misc$form
resp$form

}
\author{
Emre Gonulates
}
