% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_ndvi}
\alias{filter_ndvi}
\title{Filter NDVI}
\usage{
filter_ndvi(DT)
}
\arguments{
\item{DT}{data.table of NDVI time series}
}
\value{
filtered NDVI time series.
}
\description{
Meta function, calling all filtering steps, in order. Only defaults.
}
\examples{
# Load data.table
library(data.table)

# Read example data
ndvi <- fread(system.file("extdata", "ndvi.csv", package = "irg"))

# Use filter_ndvi to apply all filtering steps (with defaults)
filter_ndvi(ndvi)
}
\seealso{
Other filter: \code{\link{filter_qa}},
  \code{\link{filter_roll}}, \code{\link{filter_top}},
  \code{\link{filter_winter}}
}
\concept{filter}
