% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling_heatmap.R
\name{sampling_heatmap2}
\alias{sampling_heatmap2}
\title{Sampling heat map plot}
\usage{
sampling_heatmap2(
  configurations,
  parameters,
  param_names,
  sizes = c(0, 0),
  filename = NULL
)
}
\arguments{
\item{configurations}{Data frame, configurations in \code{irace} format
(example: \code{configurations = iraceResults$allConfigurations})}

\item{parameters}{List, parameter object in irace format
(example: \code{configurations = iraceResults$parameters})}

\item{param_names}{String vector of size 2, names of the parameters that should be included in the plot
(example: param_names = c("beta","alpha"))}

\item{sizes}{Numeric vector that indicated the number of intervals to be considered for numerical
parameters. This argument is positional with respect to param_names. By default,
numerical parameters are displayed using 10 intervals.
(example sizes = c(0,10))}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}
}
\value{
sampling heat map plot
}
\description{
Heatmap that displays the frequency of sampling values of two parameters.
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
sampling_heatmap2(iraceResults$allConfigurations, iraceResults$parameters, 
                  param_names=c("beta", "alpha"))
}
