% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with2Replicates.R
\name{Est2Replicates}
\alias{Est2Replicates}
\title{Estimation of ATE with Two Replicates}
\usage{
Est2Replicates(data, indA, indYerror, indX,
  constraint = c("sensitivity equals specificity", "known sensitivity",
  "known specificity", "known prevalence"), sensitivity = NULL,
  specificity = NULL, prevalence = NULL, confidence = 0.95)
}
\arguments{
\item{data}{The dataset to be analyzed in the form of R data frame}

\item{indA}{A column name indicating the treatment variable}

\item{indYerror}{A vector of two column names indicating replicates of the outcome variable}

\item{indX}{A vector of column names indicating the covariates included in the treatment model}

\item{constraint}{The constraint to be used; the default assumes sensitivity equals specificity}

\item{sensitivity}{The specified sensitivity between 0 and 1 when imposing the constraint that sensitivity is known, and the default is set to be NULL}

\item{specificity}{The specified specificity between 0 and 1 when imposing the constraint that specificity is known, and the default is set to be NULL}

\item{prevalence}{The specified prevalence between 0 and 1 when imposing the constraint that prevalence is known, and the default is set to be NULL}

\item{confidence}{The confidence level between 0 and 1; the default is 0.95 corresponding to a 95 per cent confidence interval}
}
\value{
A list of the estimate of average treatment effect, sandwich standard error, confidence interval, imposed constraint, and the information on sensitivity and specificity
}
\description{
Estimation of average treatment effect when misclassification probabilities are unknown but two independent replicates of the outcome are available
}
\examples{
#create a dataset with sensitivity=0.95 and specificity=0.85
set.seed(100)
X1=rnorm(2000)   
A=rbinom(2000,1,1/(1+exp(-0.2-X1)))
Y=rbinom(2000,1,1/(1+exp(-0.2-A-X1)))
y1=which(Y==1)
y0=which(Y==0) 
Yast1=Y
Yast1[y1]=rbinom(length(y1),1,0.95)
Yast1[y0]=rbinom(length(y0),1,0.15)
Yast2=Y
Yast2[y1]=rbinom(length(y1),1,0.95)  
Yast2[y0]=rbinom(length(y0),1,0.15)
da=data.frame(A=A,X1=X1,Yast1=Yast1,Yast2=Yast2)
head(da)
#apply the correction method assuming specificity=0.85
Est2Replicates(da,"A",c("Yast1","Yast2"),"X1","known specificity",NULL,0.85,NULL,0.95)

}
