% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo2mafft.R
\name{phylo2mafft}
\alias{phylo2mafft}
\title{Convert Trees for MAFFT}
\usage{
phylo2mafft(phy, file)
}
\arguments{
\item{phy}{A phylogenetic tree of class \code{\link{phylo}}.}

\item{file}{A character string giving a filename. May be missing, in which
case the results are only printed on the screen.}
}
\value{
A matrix coding the MAFFT-formatted tree, as a side effect the same 
  matrix is written to \code{file}.
}
\description{
Converts a phylogenetic tree of class \code{"phylo"} to a format
  usable as a guide tree by MAFFT. This function is called internally by 
  \code{\link{mafft}}.
}
\references{
The MAFFT website:
  \url{http://mafft.cbrc.jp/alignment/software/index.html}
}
\seealso{
\code{\link{mafft}} for an interface to MAFFT.
}
